/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.devui.OidcDevUiRecorder;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public abstract class AbstractDevUIProcessor {
    protected static final String CONFIG_PREFIX = "quarkus.oidc.";
    protected static final String CLIENT_ID_CONFIG_KEY = "quarkus.oidc.client-id";
    private static final String APP_TYPE_CONFIG_KEY = "quarkus.oidc.application-type";

    protected static CardPageBuildItem createProviderWebComponent(OidcDevUiRecorder recorder, Capabilities capabilities, String oidcProviderName, String oidcApplicationType, String oidcGrantType, String authorizationUrl, String tokenUrl, String logoutUrl, boolean introspectionIsAvailable, BeanContainerBuildItem beanContainer, Duration webClientTimeout, Map<String, Map<String, String>> grantOptions, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, String keycloakAdminUrl, Map<String, String> keycloakUsers, List<String> keycloakRealms, boolean alwaysLogoutUserInDevUiOnReload, VertxHttpConfig httpConfig, boolean discoverMetadata, String authServerUrl) {
        CardPageBuildItem cardPage = new CardPageBuildItem();
        cardPage.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:boxes-stacked")).title((String)(oidcProviderName == null ? "OpenId Connect Dev Console" : oidcProviderName + " provider"))).componentLink("qwc-oidc-provider.js"));
        boolean swaggerIsAvailable = capabilities.isPresent("io.quarkus.smallrye.openapi");
        boolean graphqlIsAvailable = capabilities.isPresent("io.quarkus.smallrye.graphql");
        Config config = ConfigProvider.getConfig();
        String swaggerUiPath = swaggerIsAvailable ? nonApplicationRootPathBuildItem.resolvePath((String)config.getValue("quarkus.swagger-ui.path", String.class)) : null;
        String graphqlUiPath = graphqlIsAvailable ? nonApplicationRootPathBuildItem.resolvePath((String)config.getValue("quarkus.smallrye-graphql.ui.root-path", String.class)) : null;
        cardPage.addBuildTimeData("devRoot", (Object)nonApplicationRootPathBuildItem.getNonApplicationRootPath());
        RuntimeValue runtimeProperties = recorder.getRpcServiceProperties(authorizationUrl, tokenUrl, logoutUrl, webClientTimeout, grantOptions, keycloakUsers, oidcProviderName, oidcApplicationType, oidcGrantType, introspectionIsAvailable, keycloakAdminUrl, keycloakRealms, swaggerIsAvailable, graphqlIsAvailable, swaggerUiPath, graphqlUiPath, alwaysLogoutUserInDevUiOnReload, discoverMetadata, authServerUrl);
        recorder.createJsonRPCService(beanContainer.getValue(), runtimeProperties, httpConfig);
        return cardPage;
    }

    protected static String getApplicationType() {
        return AbstractDevUIProcessor.getApplicationType(null);
    }

    protected static String getApplicationType(OidcTenantConfig providerConfig) {
        Optional appType = ConfigProvider.getConfig().getOptionalValue(APP_TYPE_CONFIG_KEY, OidcTenantConfig.ApplicationType.class);
        if (appType.isEmpty() && providerConfig != null) {
            appType = providerConfig.applicationType();
        }
        return appType.map(at -> OidcTenantConfig.ApplicationType.WEB_APP == at ? "web-app" : at.name().toLowerCase()).orElse(OidcTenantConfig.ApplicationType.SERVICE.name().toLowerCase());
    }

    protected static void registerOidcWebAppRoutes(BuildProducer<RouteBuildItem> routeProducer, OidcDevUiRecorder recorder, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute("io.quarkus.quarkus-oidc", "readSessionCookie").handler(recorder.readSessionCookieHandler()).build());
        routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute("io.quarkus.quarkus-oidc", "logout").handler(recorder.logoutHandler()).build());
    }
}

