/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.devservices.oidc.OidcDevServicesConfigBuildItem;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.AbstractDevUIProcessor;
import io.quarkus.oidc.runtime.devui.OidcDevJsonRpcService;
import io.quarkus.oidc.runtime.devui.OidcDevUiRecorder;
import io.quarkus.oidc.runtime.providers.KnownOidcProviders;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;

public class OidcDevUIProcessor
extends AbstractDevUIProcessor {
    private static final String TENANT_ENABLED_CONFIG_KEY = "quarkus.oidc.tenant-enabled";
    private static final String DISCOVERY_ENABLED_CONFIG_KEY = "quarkus.oidc.discovery-enabled";
    private static final String AUTH_SERVER_URL_CONFIG_KEY = "quarkus.oidc.auth-server-url";
    private static final String OIDC_PROVIDER_CONFIG_KEY = "quarkus.oidc.provider";
    private static final String KEYCLOAK = "Keycloak";
    private static final String ENTRAID = "Microsoft Entra ID";
    private static final Set<String> OTHER_PROVIDERS = Set.of("Auth0", "Okta", "Google", "Github", "Spotify");
    OidcBuildTimeConfig oidcConfig;

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    @Consume.List(value={@Consume(value=CoreVertxBuildItem.class), @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)})
    void prepareOidcDevConsole(Capabilities capabilities, VertxHttpConfig httpConfig, BeanContainerBuildItem beanContainer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, BuildProducer<CardPageBuildItem> cardPageProducer, OidcDevUiRecorder recorder, Optional<OidcDevServicesConfigBuildItem> oidcDevServicesConfigBuildItem) {
        String authServerUrl;
        if (!OidcDevUIProcessor.isOidcTenantEnabled() || !OidcDevUIProcessor.isClientIdSet() && oidcDevServicesConfigBuildItem.isEmpty()) {
            return;
        }
        OidcTenantConfig providerConfig = OidcDevUIProcessor.getProviderConfig();
        boolean oidcDevServicesEnabled = oidcDevServicesConfigBuildItem.isPresent();
        String string = authServerUrl = oidcDevServicesEnabled ? (String)oidcDevServicesConfigBuildItem.get().getConfig().get(AUTH_SERVER_URL_CONFIG_KEY) : OidcDevUIProcessor.getAuthServerUrl(providerConfig);
        if (authServerUrl != null) {
            boolean discoverMetadata = OidcDevUIProcessor.isDiscoveryEnabled(providerConfig);
            String providerName = OidcDevUIProcessor.tryToGetProviderName(authServerUrl);
            String keycloakAdminUrl = KEYCLOAK.equals(providerName) ? authServerUrl.substring(0, authServerUrl.indexOf("/realms/")) : null;
            CardPageBuildItem cardPage = OidcDevUIProcessor.createProviderWebComponent(recorder, capabilities, providerName, OidcDevUIProcessor.getApplicationType(providerConfig), this.oidcConfig.devui().grant().type().isPresent() ? this.oidcConfig.devui().grant().type().get().getGrantType() : "code", null, null, null, OidcDevUIProcessor.checkProviderUserInfoRequired(providerConfig), beanContainer, this.oidcConfig.devui().webClientTimeout(), this.oidcConfig.devui().grantOptions(), nonApplicationRootPathBuildItem, keycloakAdminUrl, null, null, true, httpConfig, discoverMetadata, authServerUrl);
            cardPageProducer.produce((BuildItem)cardPage);
        }
    }

    @BuildStep
    JsonRPCProvidersBuildItem produceOidcDevJsonRpcService() {
        return new JsonRPCProvidersBuildItem(OidcDevJsonRpcService.class);
    }

    private static boolean checkProviderUserInfoRequired(OidcTenantConfig providerConfig) {
        if (providerConfig != null) {
            return providerConfig.authentication().userInfoRequired().orElse(false);
        }
        return false;
    }

    private static String tryToGetProviderName(String authServerUrl) {
        if (authServerUrl.contains("/realms/")) {
            return KEYCLOAK;
        }
        if (authServerUrl.contains("microsoft")) {
            return ENTRAID;
        }
        for (String provider : OTHER_PROVIDERS) {
            if (!authServerUrl.contains(provider.toLowerCase())) continue;
            return provider;
        }
        return null;
    }

    private static String getConfigProperty(String name) {
        return (String)ConfigProvider.getConfig().getValue(name, String.class);
    }

    private static boolean isOidcTenantEnabled() {
        return OidcDevUIProcessor.getBooleanProperty(TENANT_ENABLED_CONFIG_KEY);
    }

    private static boolean isDiscoveryEnabled(OidcTenantConfig providerConfig) {
        return ConfigProvider.getConfig().getOptionalValue(DISCOVERY_ENABLED_CONFIG_KEY, Boolean.class).orElse(providerConfig != null ? providerConfig.discoveryEnabled().orElse(true) : true);
    }

    private static boolean getBooleanProperty(String name) {
        return ConfigProvider.getConfig().getOptionalValue(name, Boolean.class).orElse(true);
    }

    private static boolean isClientIdSet() {
        return ConfigUtils.isPropertyPresent((String)"quarkus.oidc.client-id");
    }

    private static String getAuthServerUrl(OidcTenantConfig providerConfig) {
        try {
            return OidcDevUIProcessor.getConfigProperty(AUTH_SERVER_URL_CONFIG_KEY);
        }
        catch (Exception ex) {
            return providerConfig != null ? (String)providerConfig.authServerUrl().get() : null;
        }
    }

    private static OidcTenantConfig getProviderConfig() {
        try {
            return ConfigProvider.getConfig().getOptionalValue(OIDC_PROVIDER_CONFIG_KEY, OidcTenantConfig.Provider.class).map(KnownOidcProviders::provider).orElse(null);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

