/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SynthesisFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.Tenant;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.oidc.runtime.BackChannelLogoutHandler;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.DefaultTokenIntrospectionUserInfoCache;
import io.quarkus.oidc.runtime.DefaultTokenStateManager;
import io.quarkus.oidc.runtime.OidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcConfigurationMetadataProducer;
import io.quarkus.oidc.runtime.OidcIdentityProvider;
import io.quarkus.oidc.runtime.OidcJsonWebTokenProducer;
import io.quarkus.oidc.runtime.OidcRecorder;
import io.quarkus.oidc.runtime.OidcSessionImpl;
import io.quarkus.oidc.runtime.OidcTokenCredentialProducer;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.providers.AzureAccessTokenCustomizer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.EagerSecurityInterceptorCandidateBuildItem;
import io.quarkus.vertx.http.deployment.SecurityInformationBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.smallrye.jwt.auth.cdi.ClaimValueProducer;
import io.smallrye.jwt.auth.cdi.CommonJwtProducer;
import io.smallrye.jwt.auth.cdi.JsonValueProducer;
import io.smallrye.jwt.auth.cdi.RawClaimTypeProducer;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.microprofile.jwt.Claim;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={IsEnabled.class})
public class OidcBuildStep {
    public static final DotName DOTNAME_SECURITY_EVENT = DotName.createSimple((String)SecurityEvent.class.getName());
    private static final DotName TENANT_NAME = DotName.createSimple(Tenant.class);
    private static final Logger LOG = Logger.getLogger(OidcBuildStep.class);

    @BuildStep
    public void provideSecurityInformation(BuildProducer<SecurityInformationBuildItem> securityInformationProducer) {
        securityInformationProducer.produce((BuildItem)SecurityInformationBuildItem.OPENIDCONNECT((String)"quarkus.oidc.auth-server-url"));
    }

    @BuildStep
    AdditionalBeanBuildItem jwtClaimIntegration(Capabilities capabilities) {
        if (!capabilities.isPresent("io.quarkus.jwt")) {
            AdditionalBeanBuildItem.Builder removable = AdditionalBeanBuildItem.builder();
            removable.addBeanClass(CommonJwtProducer.class);
            removable.addBeanClass(RawClaimTypeProducer.class);
            removable.addBeanClass(JsonValueProducer.class);
            removable.addBeanClass(ClaimValueProducer.class);
            removable.addBeanClass(Claim.class);
            return removable.build();
        }
        return null;
    }

    @BuildStep
    public void additionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        builder.addBeanClass(OidcAuthenticationMechanism.class).addBeanClass(OidcJsonWebTokenProducer.class).addBeanClass(OidcTokenCredentialProducer.class).addBeanClass(OidcConfigurationMetadataProducer.class).addBeanClass(OidcIdentityProvider.class).addBeanClass(DefaultTenantConfigResolver.class).addBeanClass(DefaultTokenStateManager.class).addBeanClass(OidcSessionImpl.class).addBeanClass(BackChannelLogoutHandler.class).addBeanClass(AzureAccessTokenCustomizer.class);
        additionalBeans.produce((BuildItem)builder.build());
    }

    @BuildStep(onlyIf={IsCacheEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public SyntheticBeanBuildItem addDefaultCacheBean(OidcConfig config, OidcRecorder recorder, CoreVertxBuildItem vertxBuildItem) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DefaultTokenIntrospectionUserInfoCache.class).unremovable()).types(new Class[]{DefaultTokenIntrospectionUserInfoCache.class, TokenIntrospectionCache.class, UserInfoCache.class})).supplier(recorder.setupTokenCache(config, vertxBuildItem.getVertx())).scope(Singleton.class)).setRuntimeInit().done();
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem enableSslInNative() {
        return new ExtensionSslNativeSupportBuildItem(Feature.OIDC);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    public SyntheticBeanBuildItem setup(OidcConfig config, OidcRecorder recorder, CoreVertxBuildItem vertxBuildItem, TlsConfig tlsConfig) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(TenantConfigBean.class).unremovable()).types(new Class[]{TenantConfigBean.class})).supplier(recorder.setup(config, vertxBuildItem.getVertx(), tlsConfig)).destroyer(TenantConfigBean.Destroyer.class)).scope(Singleton.class)).setRuntimeInit().done();
    }

    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void findSecurityEventObservers(OidcRecorder recorder, SynthesisFinishedBuildItem synthesisFinished) {
        boolean isSecurityEventObserved = synthesisFinished.getObservers().stream().anyMatch(observer -> observer.asObserver().getObservedType().name().equals((Object)DOTNAME_SECURITY_EVENT));
        recorder.setSecurityEventObserved(isSecurityEventObserved);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void produceTenantResolverInterceptors(CombinedIndexBuildItem indexBuildItem, Capabilities capabilities, OidcRecorder recorder, BuildProducer<EagerSecurityInterceptorCandidateBuildItem> producer, HttpBuildTimeConfig buildTimeConfig) {
        if (!buildTimeConfig.auth.proactive && (capabilities.isPresent("io.quarkus.resteasy.reactive") || capabilities.isPresent("io.quarkus.resteasy"))) {
            IndexView index = indexBuildItem.getIndex();
            HashMap<MethodInfo, String> candidateToTenant = new HashMap<MethodInfo, String>();
            for (AnnotationInstance annotation : index.getAnnotations(TENANT_NAME)) {
                AnnotationTarget target = annotation.target();
                if (annotation.value() == null || annotation.value().asString().isEmpty()) {
                    LOG.warnf("Annotation instance @Tenant placed on %s did not provide valid tenant", (Object)OidcBuildStep.toTargetName(target));
                    continue;
                }
                String tenant2 = annotation.value().asString();
                if (target.kind() == AnnotationTarget.Kind.METHOD) {
                    MethodInfo method2 = target.asMethod();
                    if (EagerSecurityInterceptorCandidateBuildItem.hasProperEndpointModifiers((MethodInfo)method2)) {
                        candidateToTenant.put(method2, tenant2);
                        continue;
                    }
                    LOG.warnf("Method %s is not valid endpoint, but is annotated with the '@Tenant' annotation", (Object)OidcBuildStep.toTargetName(target));
                    continue;
                }
                if (target.kind() != AnnotationTarget.Kind.CLASS) continue;
                for (MethodInfo method3 : target.asClass().methods()) {
                    if (!EagerSecurityInterceptorCandidateBuildItem.hasProperEndpointModifiers((MethodInfo)method3)) continue;
                    candidateToTenant.put(method3, tenant2);
                }
            }
            if (!candidateToTenant.isEmpty()) {
                Map<String, Consumer> tenantToInterceptor = candidateToTenant.values().stream().distinct().map(tenant -> Map.entry(tenant, recorder.createTenantResolverInterceptor(tenant))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                candidateToTenant.forEach((method, tenant) -> {
                    String[] paramTypes = (String[])method.parameterTypes().stream().map(t -> t.name().toString()).toArray(String[]::new);
                    String className = method.declaringClass().name().toString();
                    String methodName = method.name();
                    RuntimeValue description = recorder.methodInfoToDescription(className, methodName, paramTypes);
                    producer.produce((BuildItem)new EagerSecurityInterceptorCandidateBuildItem(method, description, (Consumer)tenantToInterceptor.get(tenant)));
                });
            }
        }
    }

    private static String toTargetName(AnnotationTarget target) {
        if (target.kind() == AnnotationTarget.Kind.CLASS) {
            return target.asClass().name().toString();
        }
        return target.asMethod().declaringClass().name().toString() + "#" + target.asMethod().name();
    }

    public static class IsCacheEnabled
    implements BooleanSupplier {
        OidcBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled && this.config.defaultTokenCacheEnabled;
        }
    }

    public static class IsEnabled
    implements BooleanSupplier {
        OidcBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled;
        }
    }
}

