/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.QualifierRegistrarBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.QualifierRegistrar;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.oidc.IdToken;
import io.quarkus.oidc.Tenant;
import io.quarkus.oidc.TenantFeature;
import io.quarkus.oidc.TenantIdentityProvider;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.oidc.runtime.BackChannelLogoutHandler;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.DefaultTokenIntrospectionUserInfoCache;
import io.quarkus.oidc.runtime.DefaultTokenStateManager;
import io.quarkus.oidc.runtime.OidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcConfigurationMetadataProducer;
import io.quarkus.oidc.runtime.OidcIdentityProvider;
import io.quarkus.oidc.runtime.OidcJsonWebTokenProducer;
import io.quarkus.oidc.runtime.OidcRecorder;
import io.quarkus.oidc.runtime.OidcSessionImpl;
import io.quarkus.oidc.runtime.OidcTokenCredentialProducer;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.providers.AzureAccessTokenCustomizer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.EagerSecurityInterceptorCandidateBuildItem;
import io.quarkus.vertx.http.deployment.SecurityInformationBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.smallrye.jwt.auth.cdi.ClaimValueProducer;
import io.smallrye.jwt.auth.cdi.CommonJwtProducer;
import io.smallrye.jwt.auth.cdi.JsonValueProducer;
import io.smallrye.jwt.auth.cdi.RawClaimTypeProducer;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={IsEnabled.class})
public class OidcBuildStep {
    private static final DotName TENANT_NAME = DotName.createSimple(Tenant.class);
    private static final DotName TENANT_FEATURE_NAME = DotName.createSimple(TenantFeature.class);
    private static final DotName TENANT_IDENTITY_PROVIDER_NAME = DotName.createSimple(TenantIdentityProvider.class);
    private static final Logger LOG = Logger.getLogger(OidcBuildStep.class);
    private static final DotName USER_INFO_NAME = DotName.createSimple(UserInfo.class);
    private static final DotName JSON_WEB_TOKEN_NAME = DotName.createSimple(JsonWebToken.class);
    private static final DotName ID_TOKEN_NAME = DotName.createSimple(IdToken.class);
    private static final String QUARKUS_TOKEN_PROPAGATION_PACKAGE = "io.quarkus.oidc.token.propagation";
    private static final String SMALLRYE_JWT_PACKAGE = "io.smallrye.jwt";

    @BuildStep
    public void provideSecurityInformation(BuildProducer<SecurityInformationBuildItem> securityInformationProducer) {
        securityInformationProducer.produce((BuildItem)SecurityInformationBuildItem.OPENIDCONNECT((String)"quarkus.oidc.auth-server-url"));
    }

    @BuildStep
    AdditionalBeanBuildItem jwtClaimIntegration(Capabilities capabilities) {
        if (!capabilities.isPresent("io.quarkus.jwt")) {
            AdditionalBeanBuildItem.Builder removable = AdditionalBeanBuildItem.builder();
            removable.addBeanClass(CommonJwtProducer.class);
            removable.addBeanClass(RawClaimTypeProducer.class);
            removable.addBeanClass(JsonValueProducer.class);
            removable.addBeanClass(ClaimValueProducer.class);
            removable.addBeanClass(Claim.class);
            return removable.build();
        }
        return null;
    }

    @BuildStep
    public void additionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        builder.addBeanClass(OidcAuthenticationMechanism.class).addBeanClass(OidcJsonWebTokenProducer.class).addBeanClass(OidcTokenCredentialProducer.class).addBeanClass(OidcConfigurationMetadataProducer.class).addBeanClass(OidcIdentityProvider.class).addBeanClass(DefaultTenantConfigResolver.class).addBeanClass(DefaultTokenStateManager.class).addBeanClass(OidcSessionImpl.class).addBeanClass(BackChannelLogoutHandler.class).addBeanClass(AzureAccessTokenCustomizer.class);
        additionalBeans.produce((BuildItem)builder.build());
    }

    @BuildStep(onlyIf={IsCacheEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public SyntheticBeanBuildItem addDefaultCacheBean(OidcConfig config, OidcRecorder recorder, CoreVertxBuildItem vertxBuildItem) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DefaultTokenIntrospectionUserInfoCache.class).unremovable()).types(new Class[]{DefaultTokenIntrospectionUserInfoCache.class, TokenIntrospectionCache.class, UserInfoCache.class})).supplier(recorder.setupTokenCache(config, vertxBuildItem.getVertx())).scope(Singleton.class)).setRuntimeInit().done();
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem enableSslInNative() {
        return new ExtensionSslNativeSupportBuildItem(Feature.OIDC);
    }

    @BuildStep
    QualifierRegistrarBuildItem addQualifiers() {
        return new QualifierRegistrarBuildItem(new QualifierRegistrar(){

            public Map<DotName, Set<String>> getAdditionalQualifiers() {
                return Map.of(TENANT_FEATURE_NAME, Set.of());
            }
        });
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void produceTenantIdentityProviders(BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer, OidcRecorder recorder, BeanDiscoveryFinishedBuildItem beans, CombinedIndexBuildItem combinedIndex) {
        boolean createTenantIdentityProviderForDefaultTenant;
        if (!combinedIndex.getIndex().getAnnotations(TENANT_FEATURE_NAME).isEmpty()) {
            beans.getInjectionPoints().stream().filter(ip -> ip.getRequiredQualifier(TENANT_FEATURE_NAME) != null).filter(OidcBuildStep::isTenantIdentityProviderType).map(ip -> ip.getRequiredQualifier(TENANT_FEATURE_NAME).value().asString()).distinct().forEach(tenantName -> syntheticBeanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(TenantIdentityProvider.class).addQualifier().annotation(TENANT_FEATURE_NAME).addValue("value", tenantName).done()).scope(BuiltinScope.APPLICATION.getInfo())).supplier(recorder.createTenantIdentityProvider(tenantName)).unremovable()).done()));
        }
        if (createTenantIdentityProviderForDefaultTenant = beans.getInjectionPoints().stream().filter(InjectionPointInfo::hasDefaultedQualifier).anyMatch(OidcBuildStep::isTenantIdentityProviderType)) {
            syntheticBeanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(TenantIdentityProvider.class).addQualifier(DotNames.DEFAULT)).scope(BuiltinScope.APPLICATION.getInfo())).supplier(recorder.createTenantIdentityProvider("Default")).unremovable()).done());
        }
    }

    private static boolean isTenantIdentityProviderType(InjectionPointInfo ip) {
        return TENANT_IDENTITY_PROVIDER_NAME.equals((Object)ip.getRequiredType().name());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    public SyntheticBeanBuildItem setup(OidcConfig config, OidcRecorder recorder, CoreVertxBuildItem vertxBuildItem, TlsConfig tlsConfig) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(TenantConfigBean.class).unremovable()).types(new Class[]{TenantConfigBean.class})).supplier(recorder.setup(config, vertxBuildItem.getVertx(), tlsConfig)).destroyer(TenantConfigBean.Destroyer.class)).scope(Singleton.class)).setRuntimeInit().done();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void produceTenantResolverInterceptors(CombinedIndexBuildItem indexBuildItem, Capabilities capabilities, OidcRecorder recorder, BuildProducer<EagerSecurityInterceptorCandidateBuildItem> producer, HttpBuildTimeConfig buildTimeConfig) {
        if (!buildTimeConfig.auth.proactive && (capabilities.isPresent("io.quarkus.resteasy.reactive") || capabilities.isPresent("io.quarkus.resteasy"))) {
            IndexView index = indexBuildItem.getIndex();
            HashMap<MethodInfo, String> candidateToTenant = new HashMap<MethodInfo, String>();
            for (AnnotationInstance annotation : index.getAnnotations(TENANT_NAME)) {
                AnnotationTarget target = annotation.target();
                if (annotation.value() == null || annotation.value().asString().isEmpty()) {
                    LOG.warnf("Annotation instance @Tenant placed on %s did not provide valid tenant", (Object)OidcBuildStep.toTargetName(target));
                    continue;
                }
                String tenant2 = annotation.value().asString();
                if (target.kind() == AnnotationTarget.Kind.METHOD) {
                    MethodInfo method2 = target.asMethod();
                    if (EagerSecurityInterceptorCandidateBuildItem.hasProperEndpointModifiers((MethodInfo)method2)) {
                        candidateToTenant.put(method2, tenant2);
                        continue;
                    }
                    LOG.warnf("Method %s is not valid endpoint, but is annotated with the '@Tenant' annotation", (Object)OidcBuildStep.toTargetName(target));
                    continue;
                }
                if (target.kind() != AnnotationTarget.Kind.CLASS) continue;
                for (MethodInfo method3 : target.asClass().methods()) {
                    if (!EagerSecurityInterceptorCandidateBuildItem.hasProperEndpointModifiers((MethodInfo)method3)) continue;
                    candidateToTenant.put(method3, tenant2);
                }
            }
            if (!candidateToTenant.isEmpty()) {
                Map<String, Consumer> tenantToInterceptor = candidateToTenant.values().stream().distinct().map(tenant -> Map.entry(tenant, recorder.createTenantResolverInterceptor(tenant))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                candidateToTenant.forEach((method, tenant) -> {
                    String[] paramTypes = (String[])method.parameterTypes().stream().map(t -> t.name().toString()).toArray(String[]::new);
                    String className = method.declaringClass().name().toString();
                    String methodName = method.name();
                    RuntimeValue description = recorder.methodInfoToDescription(className, methodName, paramTypes);
                    producer.produce((BuildItem)new EagerSecurityInterceptorCandidateBuildItem(method, description, (Consumer)tenantToInterceptor.get(tenant)));
                });
            }
        }
    }

    @BuildStep
    void detectUserInfoRequired(BeanRegistrationPhaseBuildItem beanRegistrationPhaseBuildItem, BuildProducer<RunTimeConfigurationDefaultBuildItem> runtimeConfigDefaultProducer) {
        if (OidcBuildStep.isInjected(beanRegistrationPhaseBuildItem, USER_INFO_NAME, null)) {
            runtimeConfigDefaultProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.oidc.authentication.user-info-required", "true"));
        }
    }

    @BuildStep
    void detectAccessTokenVerificationRequired(BeanRegistrationPhaseBuildItem beanRegistrationPhaseBuildItem, BuildProducer<RunTimeConfigurationDefaultBuildItem> runtimeConfigDefaultProducer) {
        if (OidcBuildStep.isInjected(beanRegistrationPhaseBuildItem, JSON_WEB_TOKEN_NAME, ID_TOKEN_NAME)) {
            runtimeConfigDefaultProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.oidc.authentication.verify-access-token", "true"));
        }
    }

    private static boolean isInjected(BeanRegistrationPhaseBuildItem beanRegistrationPhaseBuildItem, DotName requiredType, DotName withoutQualifier) {
        for (InjectionPointInfo injectionPoint : beanRegistrationPhaseBuildItem.getInjectionPoints()) {
            if (!requiredType.equals((Object)injectionPoint.getRequiredType().name()) || !OidcBuildStep.isApplicationPackage(injectionPoint.getTargetInfo()) || withoutQualifier != null && injectionPoint.getRequiredQualifier(withoutQualifier) != null) continue;
            LOG.debugf("%s injection point: %s", (Object)requiredType.toString(), (Object)injectionPoint.getTargetInfo());
            return true;
        }
        return false;
    }

    private static boolean isApplicationPackage(String injectionPointTargetInfo) {
        return injectionPointTargetInfo != null && !injectionPointTargetInfo.startsWith(QUARKUS_TOKEN_PROPAGATION_PACKAGE) && !injectionPointTargetInfo.startsWith(SMALLRYE_JWT_PACKAGE);
    }

    private static String toTargetName(AnnotationTarget target) {
        if (target.kind() == AnnotationTarget.Kind.CLASS) {
            return target.asClass().name().toString();
        }
        return target.asMethod().declaringClass().name().toString() + "#" + target.asMethod().name();
    }

    public static class IsCacheEnabled
    implements BooleanSupplier {
        OidcBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled && this.config.defaultTokenCacheEnabled;
        }
    }

    public static class IsEnabled
    implements BooleanSupplier {
        OidcBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled;
        }
    }
}

