/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.redis.token.state.manager.runtime;

import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.OidcRequestContext;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.value.SetArgs;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Function;

final class OidcRedisTokenStateManager
implements TokenStateManager {
    private static final String REDIS_KEY_PREFIX = "oidc:token:";
    private final ReactiveRedisDataSource dataSource;

    OidcRedisTokenStateManager(ReactiveRedisDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Uni<String> createTokenState(RoutingContext event, OidcTenantConfig oidcConfig, AuthorizationCodeTokens tokens, OidcRequestContext<String> requestContext) {
        return this.createTokenState(AuthorizationCodeTokensRecord.of(tokens), 0, OidcRedisTokenStateManager.newSetArgs(event)).onFailure().transform(AuthenticationFailedException::new);
    }

    public Uni<AuthorizationCodeTokens> getTokens(RoutingContext routingContext, OidcTenantConfig oidcConfig, String tokenState, OidcRequestContext<AuthorizationCodeTokens> requestContext) {
        return this.dataSource.value(AuthorizationCodeTokensRecord.class).get((Object)OidcRedisTokenStateManager.toTokenKey(tokenState)).onItem().ifNotNull().transform(AuthorizationCodeTokensRecord::toTokens).onFailure().transform(AuthenticationCompletionException::new);
    }

    public Uni<Void> deleteTokens(RoutingContext routingContext, OidcTenantConfig oidcConfig, String tokenState, OidcRequestContext<Void> requestContext) {
        return this.dataSource.key(String.class).del((Object[])new String[]{OidcRedisTokenStateManager.toTokenKey(tokenState)}).onFailure().recoverWithNull().replaceWithVoid();
    }

    private Uni<String> createTokenState(final AuthorizationCodeTokensRecord tokens, final int attemptCount, final SetArgs setArgs) {
        if (attemptCount >= 3) {
            return Uni.createFrom().failure((Throwable)new RuntimeException("Failed to store OIDC token state in Redis as generated key already existed"));
        }
        final String tokenState = UUID.randomUUID().toString();
        return this.dataSource.value(AuthorizationCodeTokensRecord.class).setGet((Object)OidcRedisTokenStateManager.toTokenKey(tokenState), (Object)tokens, setArgs).flatMap((Function)new Function<AuthorizationCodeTokensRecord, Uni<? extends String>>(){

            @Override
            public Uni<? extends String> apply(AuthorizationCodeTokensRecord previousValue) {
                if (previousValue == null) {
                    return Uni.createFrom().item((Object)tokenState);
                }
                return OidcRedisTokenStateManager.this.createTokenState(tokens, attemptCount + 1, setArgs);
            }
        });
    }

    private static String toTokenKey(String tokenState) {
        return REDIS_KEY_PREFIX + tokenState;
    }

    private static SetArgs newSetArgs(RoutingContext event) {
        return new SetArgs().nx().exAt(OidcRedisTokenStateManager.expiresAt(event));
    }

    private static Instant expiresAt(RoutingContext event) {
        return Instant.now().plusSeconds((Long)event.get("session-max-age"));
    }

    record AuthorizationCodeTokensRecord(String idToken, String accessToken, String refreshToken, Long accessTokenExpiresIn) {
        private static AuthorizationCodeTokensRecord of(AuthorizationCodeTokens tokens) {
            return new AuthorizationCodeTokensRecord(tokens.getIdToken(), tokens.getAccessToken(), tokens.getRefreshToken(), tokens.getAccessTokenExpiresIn());
        }

        private AuthorizationCodeTokens toTokens() {
            return new AuthorizationCodeTokens(this.idToken, this.accessToken, this.refreshToken, this.accessTokenExpiresIn);
        }
    }
}

