/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.EnableAllSecurityServicesBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.oidc.deployment.OidcBuildStep;
import io.quarkus.oidc.token.propagation.AccessToken;
import io.quarkus.oidc.token.propagation.AccessTokenRequestFilter;
import io.quarkus.oidc.token.propagation.runtime.OidcTokenPropagationConfig;
import io.quarkus.restclient.deployment.RestClientAnnotationProviderBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import org.jboss.jandex.DotName;

public class OidcTokenPropagationBuildStep {
    private static final DotName TOKEN_CREDENTIAL = DotName.createSimple((String)AccessToken.class.getName());
    OidcTokenPropagationConfig config;

    @BuildStep(onlyIf={OidcBuildStep.IsEnabled.class})
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(Feature.OIDC_TOKEN_PROPAGATION);
    }

    @BuildStep(onlyIf={OidcBuildStep.IsEnabled.class})
    EnableAllSecurityServicesBuildItem security() {
        return new EnableAllSecurityServicesBuildItem();
    }

    @BuildStep(onlyIf={OidcBuildStep.IsEnabled.class})
    void registerProvider(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ResteasyJaxrsProviderBuildItem> jaxrsProviders, BuildProducer<RestClientAnnotationProviderBuildItem> restAnnotationProvider) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(AccessTokenRequestFilter.class));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{AccessTokenRequestFilter.class}));
        if (this.config.registerFilter) {
            jaxrsProviders.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(AccessTokenRequestFilter.class.getName()));
        } else {
            restAnnotationProvider.produce((BuildItem)new RestClientAnnotationProviderBuildItem(TOKEN_CREDENTIAL, AccessTokenRequestFilter.class));
        }
    }
}

