/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.oidc.token.propagation.AccessToken;
import io.quarkus.oidc.token.propagation.AccessTokenRequestFilter;
import io.quarkus.oidc.token.propagation.JsonWebToken;
import io.quarkus.oidc.token.propagation.JsonWebTokenRequestFilter;
import io.quarkus.oidc.token.propagation.runtime.OidcTokenPropagationBuildTimeConfig;
import io.quarkus.oidc.token.propagation.runtime.OidcTokenPropagationConfig;
import io.quarkus.restclient.deployment.RestClientAnnotationProviderBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import java.util.function.BooleanSupplier;
import org.jboss.jandex.DotName;

public class OidcTokenPropagationBuildStep {
    private static final DotName ACCESS_TOKEN_CREDENTIAL = DotName.createSimple((String)AccessToken.class.getName());
    private static final DotName JWT_ACCESS_TOKEN_CREDENTIAL = DotName.createSimple((String)JsonWebToken.class.getName());
    OidcTokenPropagationConfig config;

    @BuildStep(onlyIf={IsEnabled.class})
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(Feature.OIDC_TOKEN_PROPAGATION);
    }

    @BuildStep(onlyIf={IsEnabled.class})
    void registerProvider(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ResteasyJaxrsProviderBuildItem> jaxrsProviders, BuildProducer<RestClientAnnotationProviderBuildItem> restAnnotationProvider) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(AccessTokenRequestFilter.class));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(JsonWebTokenRequestFilter.class));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{AccessTokenRequestFilter.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{JsonWebTokenRequestFilter.class}));
        if (this.config.registerFilter) {
            Class filterClass = this.config.jsonWebToken ? JsonWebTokenRequestFilter.class : AccessTokenRequestFilter.class;
            jaxrsProviders.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(filterClass.getName()));
        } else {
            restAnnotationProvider.produce((BuildItem)new RestClientAnnotationProviderBuildItem(ACCESS_TOKEN_CREDENTIAL, AccessTokenRequestFilter.class));
            restAnnotationProvider.produce((BuildItem)new RestClientAnnotationProviderBuildItem(JWT_ACCESS_TOKEN_CREDENTIAL, JsonWebTokenRequestFilter.class));
        }
    }

    public static class IsEnabled
    implements BooleanSupplier {
        OidcTokenPropagationBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled;
        }
    }
}

