/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation.reactive;

import io.quarkus.security.credential.TokenCredential;
import javax.annotation.Priority;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestFilter;

@Priority(value=1000)
public class AccessTokenRequestReactiveFilter
implements ResteasyReactiveClientRequestFilter {
    private static final Logger LOG = Logger.getLogger(AccessTokenRequestReactiveFilter.class);
    private static final String BEARER_SCHEME_WITH_SPACE = "Bearer ";
    @Inject
    Instance<TokenCredential> accessToken;

    public void filter(ResteasyReactiveClientRequestContext requestContext) {
        if (this.verifyTokenInstance(requestContext)) {
            this.propagateToken(requestContext);
        }
    }

    public void propagateToken(ResteasyReactiveClientRequestContext requestContext) {
        if (((TokenCredential)this.accessToken.get()).getToken() != null) {
            requestContext.getHeaders().add((Object)"Authorization", (Object)(BEARER_SCHEME_WITH_SPACE + ((TokenCredential)this.accessToken.get()).getToken()));
        } else {
            LOG.debugf("Injected access token is null, aborting the request with HTTP 401 error", new Object[0]);
            this.abortRequest(requestContext);
        }
    }

    protected boolean verifyTokenInstance(ResteasyReactiveClientRequestContext requestContext) {
        if (!this.accessToken.isResolvable()) {
            LOG.debugf("Access token is not injected, aborting the request with HTTP 401 error", new Object[0]);
            this.abortRequest(requestContext);
            return false;
        }
        if (this.accessToken.isAmbiguous()) {
            LOG.debugf("More than one access token instance is available, aborting the request with HTTP 401 error", new Object[0]);
            this.abortRequest(requestContext);
            return false;
        }
        return true;
    }

    protected void abortRequest(ResteasyReactiveClientRequestContext requestContext) {
        requestContext.abortWith(Response.status((int)401).build());
    }
}

