/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation;

import io.quarkus.oidc.AccessTokenCredential;
import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.jboss.logging.Logger;

@Provider
@Singleton
@Priority(value=1000)
public class AccessTokenRequestFilter
implements ClientRequestFilter {
    private static final Logger LOG = Logger.getLogger(AccessTokenRequestFilter.class);
    private static final String BEARER_SCHEME_WITH_SPACE = "Bearer ";
    @Inject
    AccessTokenCredential tokenCredential;

    public void filter(ClientRequestContext requestContext) throws IOException {
        try {
            requestContext.getHeaders().add((Object)"Authorization", (Object)(BEARER_SCHEME_WITH_SPACE + this.tokenCredential.getToken()));
        }
        catch (Exception ex) {
            LOG.debugf("Access token is not available, aborting the request with HTTP 401 error: %s", (Object)ex.getMessage());
            requestContext.abortWith(Response.status((int)401).build());
        }
    }
}

