/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClients;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.token.propagation.runtime.AbstractTokenRequestFilter;
import io.quarkus.security.credential.TokenCredential;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestContext;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class AccessTokenRequestFilter
extends AbstractTokenRequestFilter {
    private static final String EXCHANGE_SUBJECT_TOKEN = "subject_token";
    @Inject
    Instance<TokenCredential> accessToken;
    @Inject
    @ConfigProperty(name="quarkus.oidc-token-propagation.client-name")
    Optional<String> clientName;
    @Inject
    @ConfigProperty(name="quarkus.oidc-token-propagation.exchange-token")
    boolean exchangeToken;
    OidcClient exchangeTokenClient;

    @PostConstruct
    public void initExchangeTokenClient() {
        if (this.exchangeToken) {
            OidcClients clients = (OidcClients)Arc.container().instance(OidcClients.class, new Annotation[0]).get();
            this.exchangeTokenClient = this.clientName.isPresent() ? clients.getClient(this.clientName.get()) : clients.getClient();
        }
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (this.verifyTokenInstance(requestContext, this.accessToken)) {
            this.propagateToken(requestContext, this.exchangeTokenIfNeeded(((TokenCredential)this.accessToken.get()).getToken()));
        }
    }

    private String exchangeTokenIfNeeded(String token) {
        if (this.exchangeTokenClient != null) {
            return ((Tokens)this.exchangeTokenClient.getTokens(Collections.singletonMap(EXCHANGE_SUBJECT_TOKEN, token)).await().indefinitely()).getAccessToken();
        }
        return token;
    }
}

