/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClientConfig;
import io.quarkus.oidc.client.OidcClients;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.token.propagation.runtime.AbstractTokenRequestFilter;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.security.credential.TokenCredential;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.ClientRequestContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class AccessTokenRequestFilter
extends AbstractTokenRequestFilter {
    @Inject
    Instance<TokenCredential> accessToken;
    @Inject
    @ConfigProperty(name="quarkus.oidc-token-propagation.client-name")
    Optional<String> oidcClientName;
    @Inject
    @ConfigProperty(name="quarkus.oidc-token-propagation.exchange-token")
    boolean exchangeToken;
    OidcClient exchangeTokenClient;
    String exchangeTokenProperty;

    @PostConstruct
    public void initExchangeTokenClient() {
        if (this.exchangeToken) {
            OidcClients clients = (OidcClients)Arc.container().instance(OidcClients.class, new Annotation[0]).get();
            this.exchangeTokenClient = this.oidcClientName.isPresent() ? clients.getClient(this.oidcClientName.get()) : clients.getClient();
            OidcClientConfig.Grant.Type exchangeTokenGrantType = (OidcClientConfig.Grant.Type)ConfigProvider.getConfig().getValue("quarkus.oidc-client." + (String)(this.oidcClientName.isPresent() ? this.oidcClientName.get() + "." : "") + "grant.type", OidcClientConfig.Grant.Type.class);
            if (exchangeTokenGrantType == OidcClientConfig.Grant.Type.EXCHANGE) {
                this.exchangeTokenProperty = "subject_token";
            } else if (exchangeTokenGrantType == OidcClientConfig.Grant.Type.JWT) {
                this.exchangeTokenProperty = "assertion";
            } else {
                throw new ConfigurationException("Token exchange is required but OIDC client is configured to use the " + exchangeTokenGrantType.getGrantType() + " grantType");
            }
        }
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (this.verifyTokenInstance(requestContext, this.accessToken)) {
            this.propagateToken(requestContext, this.exchangeTokenIfNeeded(((TokenCredential)this.accessToken.get()).getToken()));
        }
    }

    private String exchangeTokenIfNeeded(String token) {
        if (this.exchangeTokenClient != null) {
            return ((Tokens)this.exchangeTokenClient.getTokens(Collections.singletonMap(this.exchangeTokenProperty, token)).await().indefinitely()).getAccessToken();
        }
        return token;
    }
}

