/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.oidc.OidcConfig;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.HTTPAuthenticationMechanism;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class VertxOAuth2AuthenticationMechanism
implements HTTPAuthenticationMechanism {
    private static final String BEARER = "Bearer";
    private volatile String authServerURI;
    private volatile OAuth2Auth auth;
    private volatile OidcConfig config;

    public OidcConfig getConfig() {
        return this.config;
    }

    public VertxOAuth2AuthenticationMechanism setConfig(OidcConfig config) {
        this.config = config;
        return this;
    }

    public String getAuthServerURI() {
        return this.authServerURI;
    }

    public VertxOAuth2AuthenticationMechanism setAuthServerURI(String authServerURI) {
        this.authServerURI = authServerURI;
        return this;
    }

    public OAuth2Auth getAuth() {
        return this.auth;
    }

    public VertxOAuth2AuthenticationMechanism setAuth(OAuth2Auth auth) {
        this.auth = auth;
        return this;
    }

    public CompletionStage<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        HttpServerRequest request = context.request();
        String authorization = request.headers().get(HttpHeaders.AUTHORIZATION);
        if (authorization == null) {
            return CompletableFuture.completedFuture(null);
        }
        int idx = authorization.indexOf(32);
        if (idx <= 0) {
            return CompletableFuture.completedFuture(null);
        }
        if (!BEARER.equalsIgnoreCase(authorization.substring(0, idx))) {
            return CompletableFuture.completedFuture(null);
        }
        String token = authorization.substring(idx + 1);
        return identityProviderManager.authenticate((AuthenticationRequest)new TokenAuthenticationRequest(new TokenCredential(token, BEARER)));
    }

    public CompletionStage<Boolean> sendChallenge(RoutingContext context) {
        context.response().setStatusCode(302);
        context.response().headers().set(HttpHeaders.LOCATION, (CharSequence)this.authURI(this.authServerURI));
        return CompletableFuture.completedFuture(true);
    }

    private String authURI(String redirectURL) {
        JsonObject config = new JsonObject().put("state", redirectURL);
        config.put("redirect_uri", this.authServerURI);
        return this.auth.authorizeURL(config);
    }
}

