/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.oidc.VertxJwtCallerPrincipal;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import java.security.Principal;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;

@ApplicationScoped
public class VertxOAuth2IdentityProvider
implements IdentityProvider<TokenAuthenticationRequest> {
    private volatile OAuth2Auth auth;

    public OAuth2Auth getAuth() {
        return this.auth;
    }

    public VertxOAuth2IdentityProvider setAuth(OAuth2Auth auth) {
        this.auth = auth;
        return this;
    }

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public CompletionStage<SecurityIdentity> authenticate(final TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        final CompletableFuture<SecurityIdentity> result = new CompletableFuture<SecurityIdentity>();
        this.auth.decodeToken(request.getToken().getToken(), (Handler)new Handler<AsyncResult<AccessToken>>(){

            public void handle(AsyncResult<AccessToken> event) {
                JsonArray roles;
                if (event.failed()) {
                    result.completeExceptionally(event.cause());
                    return;
                }
                AccessToken token = (AccessToken)event.result();
                QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
                try {
                    JwtClaims jwtClaims = JwtClaims.parse((String)token.accessToken().encode());
                    String username = token.principal().getString("username");
                    builder.setPrincipal((Principal)((Object)new VertxJwtCallerPrincipal(username, jwtClaims)));
                }
                catch (InvalidJwtException e) {
                    result.completeExceptionally(e);
                    return;
                }
                JsonObject realmAccess = token.accessToken().getJsonObject("realm_access");
                if (realmAccess != null && (roles = realmAccess.getJsonArray("roles")) != null) {
                    for (Object authority : roles) {
                        builder.addRole(authority.toString());
                    }
                }
                builder.addCredential((Credential)request.getToken());
                result.complete(builder.build());
            }
        });
        return result;
    }
}

