/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.RefreshToken;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.CookieImpl;
import java.net.URI;
import java.security.Permission;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class CodeAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    private static final String STATE_COOKIE_NAME = "q_auth";
    private static final String SESSION_COOKIE_NAME = "q_session";
    private static final String SESSION_COOKIE_DELIM = "___";

    private static QuarkusSecurityIdentity augmentIdentity(final SecurityIdentity securityIdentity, String accessToken, String refreshToken) {
        RefreshToken refreshTokenCredential = new RefreshToken(refreshToken);
        return QuarkusSecurityIdentity.builder().setPrincipal(securityIdentity.getPrincipal()).addCredentials(securityIdentity.getCredentials()).addCredential((Credential)new AccessTokenCredential(accessToken, refreshTokenCredential)).addCredential((Credential)refreshTokenCredential).addRoles(securityIdentity.getRoles()).addAttributes(securityIdentity.getAttributes()).addPermissionChecker((Function)new Function<Permission, CompletionStage<Boolean>>(){

            @Override
            public CompletionStage<Boolean> apply(Permission permission) {
                return securityIdentity.checkPermission(permission);
            }
        }).build();
    }

    public CompletionStage<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        Cookie sessionCookie = context.request().getCookie(SESSION_COOKIE_NAME);
        if (sessionCookie != null) {
            final String[] tokens = sessionCookie.getValue().split(SESSION_COOKIE_DELIM);
            return this.authenticate(identityProviderManager, new IdTokenCredential(tokens[0])).thenCompose(new Function<SecurityIdentity, CompletionStage<SecurityIdentity>>(){

                @Override
                public CompletionStage<SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                    return CompletableFuture.completedFuture(CodeAuthenticationMechanism.augmentIdentity(securityIdentity, tokens[1], tokens[2]));
                }
            });
        }
        return this.performCodeFlow(identityProviderManager, context);
    }

    public CompletionStage<ChallengeData> getChallenge(RoutingContext context) {
        this.removeSessionCookie(context);
        JsonObject params = new JsonObject();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("openid");
        scopes.addAll(this.config.authentication.scopes);
        params.put("scopes", new JsonArray(scopes));
        params.put("redirect_uri", this.buildRedirectUri(context));
        params.put("state", this.generateState(context));
        ChallengeData challenge = new ChallengeData(HttpResponseStatus.FOUND.code(), HttpHeaders.LOCATION, this.auth.authorizeURL(params));
        return CompletableFuture.completedFuture(challenge);
    }

    private CompletionStage<SecurityIdentity> performCodeFlow(IdentityProviderManager identityProviderManager, RoutingContext context) {
        JsonObject params = new JsonObject();
        String code = context.request().getParam("code");
        if (code == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<SecurityIdentity> cf = new CompletableFuture<SecurityIdentity>();
        params.put("code", code);
        params.put("redirect_uri", this.buildRedirectUri(context));
        this.auth.authenticate(params, userAsyncResult -> {
            if (userAsyncResult.failed()) {
                cf.completeExceptionally((Throwable)new AuthenticationFailedException());
            } else {
                AccessToken result = (AccessToken)AccessToken.class.cast(userAsyncResult.result());
                this.authenticate(identityProviderManager, new IdTokenCredential(result.opaqueIdToken())).whenCompleteAsync((securityIdentity, throwable) -> {
                    if (throwable != null) {
                        cf.completeExceptionally((Throwable)throwable);
                    } else {
                        this.processSuccessfulAuthentication(context, cf, result, (SecurityIdentity)securityIdentity);
                    }
                });
            }
        });
        return cf;
    }

    private void processSuccessfulAuthentication(RoutingContext context, CompletableFuture<SecurityIdentity> cf, AccessToken result, SecurityIdentity securityIdentity) {
        this.removeSessionCookie(context);
        CookieImpl cookie = new CookieImpl(SESSION_COOKIE_NAME, result.opaqueIdToken() + SESSION_COOKIE_DELIM + result.opaqueAccessToken() + SESSION_COOKIE_DELIM + result.opaqueRefreshToken());
        cookie.setMaxAge((long)result.idToken().getInteger("exp").intValue());
        cookie.setSecure(context.request().isSSL());
        cookie.setHttpOnly(true);
        context.response().addCookie((Cookie)cookie);
        cf.complete((SecurityIdentity)CodeAuthenticationMechanism.augmentIdentity(securityIdentity, result.opaqueAccessToken(), result.opaqueRefreshToken()));
    }

    private String generateState(RoutingContext context) {
        CookieImpl cookie = new CookieImpl(STATE_COOKIE_NAME, UUID.randomUUID().toString());
        cookie.setHttpOnly(true);
        cookie.setSecure(context.request().isSSL());
        cookie.setMaxAge(-1L);
        context.response().addCookie((Cookie)cookie);
        return cookie.getValue();
    }

    private String buildRedirectUri(RoutingContext context) {
        URI absoluteUri = URI.create(context.request().absoluteURI());
        StringBuilder builder = new StringBuilder(context.request().scheme()).append("://").append(absoluteUri.getAuthority()).append(absoluteUri.getPath());
        return builder.toString();
    }

    private void removeSessionCookie(RoutingContext context) {
        context.response().removeCookie(SESSION_COOKIE_NAME, true);
    }
}

