/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2TokenImpl;
import io.vertx.ext.auth.oauth2.providers.KeycloakAuth;
import io.vertx.ext.jwt.JWT;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class OidcRuntimeClient {
    final OAuth2Auth auth;

    public OidcRuntimeClient(OAuth2Auth auth) {
        this.auth = auth;
    }

    public String authorizationURL() {
        OAuth2ClientOptions config = ((OAuth2AuthProviderImpl)OAuth2AuthProviderImpl.class.cast(this.auth)).getConfig();
        String path = config.getAuthorizationPath();
        return path.charAt(0) == '/' ? config.getSite() + path : path;
    }

    public void verifyToken(final UniEmitter<? super TokenVerificationResult> uniEmitter, TenantConfigContext resolvedContext, String token) {
        resolvedContext.client.decodeToken(token, new Handler<AsyncResult<AccessToken>>(){

            public void handle(AsyncResult<AccessToken> event) {
                if (event.failed()) {
                    uniEmitter.fail((Throwable)new AuthenticationFailedException(event.cause()));
                } else {
                    uniEmitter.complete((Object)new TokenVerificationResult(((AccessToken)event.result()).accessToken(), ((AccessToken)event.result()).principal()));
                }
            }
        });
    }

    public Uni<TokenVerificationResult> verifyTokenUni(final TenantConfigContext resolvedContext, final String token) {
        return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super TokenVerificationResult>>(){

            @Override
            public void accept(UniEmitter<? super TokenVerificationResult> emitter) {
                OidcRuntimeClient.this.verifyToken(emitter, resolvedContext, token);
            }
        });
    }

    public void refreshToken(final UniEmitter<? super AuthorizationCodeTokens> emitter, final String refreshToken) {
        final OAuth2TokenImpl token = new OAuth2TokenImpl(this.auth, new JsonObject());
        token.principal().put("refresh_token", refreshToken);
        token.refresh((Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.succeeded()) {
                    String opaqueIdToken = token.opaqueIdToken();
                    String opaqueAccessToken = token.opaqueAccessToken();
                    String opaqueRefreshToken = token.opaqueRefreshToken() == null ? refreshToken : token.opaqueRefreshToken();
                    AuthorizationCodeTokens tokens = new AuthorizationCodeTokens(opaqueIdToken, opaqueAccessToken, opaqueRefreshToken);
                    emitter.complete((Object)tokens);
                } else {
                    emitter.fail(result.cause());
                }
            }
        });
    }

    public void getCodeFlowTokens(final UniEmitter<? super AuthorizationCodeTokens> emitter, JsonObject params) {
        this.auth.authenticate(params, (Handler)new Handler<AsyncResult<User>>(){

            public void handle(AsyncResult<User> result) {
                if (result.succeeded()) {
                    AccessToken token = (AccessToken)AccessToken.class.cast(result.result());
                    String opaqueIdToken = token.opaqueIdToken();
                    String opaqueAccessToken = token.opaqueAccessToken();
                    String opaqueRefreshToken = token.opaqueRefreshToken();
                    AuthorizationCodeTokens tokens = new AuthorizationCodeTokens(opaqueIdToken, opaqueAccessToken, opaqueRefreshToken);
                    emitter.complete((Object)tokens);
                } else {
                    emitter.fail(result.cause());
                }
            }
        });
    }

    public String getLogoutPath() {
        return ((OAuth2AuthProviderImpl)OAuth2AuthProviderImpl.class.cast(this.auth)).getConfig().getLogoutPath();
    }

    public void decodeToken(String token, Handler<AsyncResult<AccessToken>> resultHandler) {
        this.auth.decodeToken(token, resultHandler);
    }

    public void createUserInfoToken(final UniEmitter<? super JsonObject> uniEmitter, RoutingContext vertxContext, TokenAuthenticationRequest request) {
        OAuth2TokenImpl tokenImpl = new OAuth2TokenImpl(this.auth, new JsonObject());
        String accessToken = (String)vertxContext.get("access_token");
        if (accessToken == null) {
            accessToken = request.getToken().getToken();
        }
        tokenImpl.principal().put("access_token", accessToken);
        tokenImpl.userInfo((Handler)new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> event) {
                if (event.failed()) {
                    uniEmitter.fail((Throwable)new AuthenticationFailedException(event.cause()));
                } else {
                    uniEmitter.complete(event.result());
                }
            }
        });
    }

    public static OidcRuntimeClient discoverOidcEndpoints(final Vertx vertx, final OAuth2ClientOptions options, final OidcTenantConfig oidcConfig) {
        return (OidcRuntimeClient)Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super OidcRuntimeClient>>(){

            @Override
            public void accept(final UniEmitter<? super OidcRuntimeClient> uniEmitter) {
                KeycloakAuth.discover((Vertx)vertx, (OAuth2ClientOptions)options, (Handler)new Handler<AsyncResult<OAuth2Auth>>(){

                    public void handle(AsyncResult<OAuth2Auth> event) {
                        if (event.failed()) {
                            uniEmitter.fail((Throwable)OidcRuntimeClient.toOidcException(event.cause(), options.getSite()));
                        } else {
                            uniEmitter.complete((Object)OidcRuntimeClient.createClient((OAuth2Auth)event.result(), oidcConfig));
                        }
                    }
                });
            }
        }).await().atMost(Duration.ofSeconds(OidcCommonUtils.getMaximumConnectionDelay((OidcCommonConfig)oidcConfig) + 3L));
    }

    public static OidcRuntimeClient setOidcEndpoints(final Vertx vertx, final OAuth2ClientOptions options, final OidcTenantConfig oidcConfig) {
        if (options.getJwkPath() != null) {
            return (OidcRuntimeClient)Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super OidcRuntimeClient>>(){

                @Override
                public void accept(UniEmitter<? super OidcRuntimeClient> uniEmitter) {
                    OAuth2Auth auth = OAuth2Auth.create((Vertx)vertx, (OAuth2ClientOptions)options);
                    auth.loadJWK(res -> {
                        if (res.failed()) {
                            uniEmitter.fail((Throwable)OidcRuntimeClient.toOidcException(res.cause(), options.getSite()));
                        } else {
                            uniEmitter.complete((Object)OidcRuntimeClient.createClient(auth, oidcConfig));
                        }
                    });
                }
            }).await().atMost(Duration.ofSeconds(OidcCommonUtils.getMaximumConnectionDelay((OidcCommonConfig)oidcConfig) + 3L));
        }
        return new OidcRuntimeClient(OAuth2Auth.create((Vertx)vertx, (OAuth2ClientOptions)options));
    }

    private static OidcRuntimeClient createClient(OAuth2Auth client, OidcTenantConfig oidcConfig) {
        client.missingKeyHandler((Handler)new JwkSetRefreshHandler(client, oidcConfig.token.forcedJwkRefreshInterval));
        return new OidcRuntimeClient(client);
    }

    public static OidcRuntimeClient createClientWithPublicKey(OAuth2ClientOptions options, String publicKey) {
        options.addPubSecKey(new PubSecKeyOptions().setAlgorithm("RS256").setPublicKey(publicKey));
        return new OidcRuntimeClient((OAuth2Auth)new OAuth2AuthProviderImpl(null, options));
    }

    protected static OIDCException toOidcException(Throwable cause, String authServerUrl) {
        String message = OidcCommonUtils.formatConnectionErrorMessage((String)authServerUrl);
        return new OIDCException(message, cause);
    }

    public JsonObject validateTokenWithoutOidcServer(String token) throws Exception {
        OAuth2AuthProviderImpl authImpl = (OAuth2AuthProviderImpl)this.auth;
        JWT jwt = authImpl.getJWT();
        JsonObject tokenJson = jwt.decode(token);
        jwt.isExpired(tokenJson, authImpl.getConfig().getJWTOptions());
        return tokenJson;
    }

    public static class JwkSetRefreshHandler
    implements Handler<String> {
        private static final Logger LOG = Logger.getLogger(JwkSetRefreshHandler.class);
        private OAuth2Auth auth;
        private volatile long lastForcedRefreshTime;
        private volatile long forcedJwksRefreshIntervalMilliSecs;

        public JwkSetRefreshHandler(OAuth2Auth auth, Duration forcedJwksRefreshInterval) {
            this.auth = auth;
            this.forcedJwksRefreshIntervalMilliSecs = forcedJwksRefreshInterval.toMillis();
        }

        public void handle(String kid) {
            long now = System.currentTimeMillis();
            if (now > this.lastForcedRefreshTime + this.forcedJwksRefreshIntervalMilliSecs) {
                this.lastForcedRefreshTime = now;
                LOG.debugf("No JWK with %s key id is available, trying to refresh the JWK set", (Object)kid);
                this.auth.loadJWK(res -> {
                    if (res.failed()) {
                        LOG.debugf("Failed to refresh the JWK set: %s", (Object)res.cause());
                    }
                });
            }
        }
    }
}

