/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class BearerAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    public CompletionStage<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        String token = this.extractBearerToken(context);
        if (token != null) {
            return this.authenticate(identityProviderManager, new AccessTokenCredential(token, context));
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletionStage<ChallengeData> getChallenge(RoutingContext context) {
        String bearerToken = this.extractBearerToken(context);
        if (bearerToken == null) {
            return CompletableFuture.completedFuture(new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), null, null));
        }
        return CompletableFuture.completedFuture(new ChallengeData(HttpResponseStatus.FORBIDDEN.code(), null, null));
    }

    private String extractBearerToken(RoutingContext context) {
        HttpServerRequest request = context.request();
        String authorization = request.headers().get(HttpHeaders.AUTHORIZATION);
        if (authorization == null) {
            return null;
        }
        int idx = authorization.indexOf(32);
        if (idx <= 0 || !"Bearer".equalsIgnoreCase(authorization.substring(0, idx))) {
            return null;
        }
        String token = authorization.substring(idx + 1);
        return token;
    }
}

