/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.runtime.BearerAuthenticationMechanism;
import io.quarkus.oidc.runtime.CodeAuthenticationMechanism;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class OidcAuthenticationMechanism
implements HttpAuthenticationMechanism {
    @Inject
    DefaultTenantConfigResolver resolver;
    private BearerAuthenticationMechanism bearerAuth = new BearerAuthenticationMechanism();
    private CodeAuthenticationMechanism codeAuth = new CodeAuthenticationMechanism();

    public CompletionStage<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        return this.isWebApp(context) ? this.codeAuth.authenticate(context, identityProviderManager, this.resolver) : this.bearerAuth.authenticate(context, identityProviderManager, this.resolver);
    }

    public CompletionStage<ChallengeData> getChallenge(RoutingContext context) {
        return this.isWebApp(context) ? this.codeAuth.getChallenge(context, this.resolver) : this.bearerAuth.getChallenge(context, this.resolver);
    }

    private boolean isWebApp(RoutingContext context) {
        return OidcTenantConfig.ApplicationType.WEB_APP == this.resolver.resolve((RoutingContext)context, (boolean)false).oidcConfig.applicationType;
    }
}

