/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.providers.KeycloakAuth;
import io.vertx.ext.jwt.JWTOptions;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class OidcRecorder {
    private static final Logger LOG = Logger.getLogger(OidcRecorder.class);

    public void setup(OidcConfig config, Supplier<Vertx> vertx, BeanContainer beanContainer) {
        final Vertx vertxValue = vertx.get();
        HashMap<String, TenantConfigContext> tenantsConfig = new HashMap<String, TenantConfigContext>();
        for (Map.Entry<String, OidcTenantConfig> tenant : config.namedTenants.entrySet()) {
            if (config.defaultTenant.getTenantId().isPresent() && tenant.getKey().equals(config.defaultTenant.getTenantId().get())) {
                throw new OIDCException("tenant-id '" + tenant.getKey() + "' duplicates the default tenant-id");
            }
            if (tenant.getValue().getTenantId().isPresent() && !tenant.getKey().equals(tenant.getValue().getTenantId().get())) {
                throw new OIDCException("Configuration has 2 different tenant-id values: '" + tenant.getKey() + "' and '" + tenant.getValue().getTenantId().get() + "'");
            }
            tenantsConfig.put(tenant.getKey(), this.createTenantContext(vertxValue, tenant.getValue()));
        }
        DefaultTenantConfigResolver resolver = (DefaultTenantConfigResolver)beanContainer.instance(DefaultTenantConfigResolver.class, new Annotation[0]);
        resolver.setDefaultTenant(this.createTenantContext(vertxValue, config.defaultTenant));
        resolver.setTenantsConfig(tenantsConfig);
        resolver.setTenantConfigContextFactory(new Function<OidcTenantConfig, TenantConfigContext>(){

            @Override
            public TenantConfigContext apply(OidcTenantConfig config) {
                return OidcRecorder.this.createTenantContext(vertxValue, config);
            }
        });
    }

    private TenantConfigContext createTenantContext(Vertx vertx, OidcTenantConfig oidcConfig) {
        long connectionRetryCount;
        OAuth2ClientOptions options = new OAuth2ClientOptions();
        if (!oidcConfig.getAuthServerUrl().isPresent()) {
            return null;
        }
        options.setSite(oidcConfig.getAuthServerUrl().get());
        if (oidcConfig.getIntrospectionPath().isPresent()) {
            options.setIntrospectionPath(oidcConfig.getIntrospectionPath().get());
        }
        if (oidcConfig.getJwksPath().isPresent()) {
            options.setJwkPath(oidcConfig.getJwksPath().get());
        }
        if (oidcConfig.getClientId().isPresent()) {
            options.setClientID(oidcConfig.getClientId().get());
        }
        if (oidcConfig.getCredentials().secret.isPresent()) {
            options.setClientSecret(oidcConfig.getCredentials().secret.get());
        }
        if (oidcConfig.getPublicKey().isPresent()) {
            options.addPubSecKey(new PubSecKeyOptions().setAlgorithm("RS256").setPublicKey(oidcConfig.getPublicKey().get()));
        }
        if (oidcConfig.getToken().issuer.isPresent()) {
            options.setValidateIssuer(false);
        }
        if (oidcConfig.getToken().getExpirationGrace().isPresent()) {
            JWTOptions jwtOptions = new JWTOptions();
            jwtOptions.setLeeway(oidcConfig.getToken().getExpirationGrace().get().intValue());
            options.setJWTOptions(jwtOptions);
        }
        long connectionDelayInSecs = oidcConfig.getConnectionDelay().isPresent() ? oidcConfig.getConnectionDelay().get().toMillis() / 1000L : 0L;
        long l = connectionRetryCount = connectionDelayInSecs > 1L ? connectionDelayInSecs / 2L : 1L;
        if (connectionRetryCount > 1L) {
            LOG.infof("Connecting to IDP for up to %d times every 2 seconds", (Object)connectionRetryCount);
        }
        OAuth2Auth auth = null;
        for (long i = 0L; i < connectionRetryCount; ++i) {
            try {
                final CompletableFuture cf = new CompletableFuture();
                KeycloakAuth.discover((Vertx)vertx, (OAuth2ClientOptions)options, (Handler)new Handler<AsyncResult<OAuth2Auth>>(){

                    public void handle(AsyncResult<OAuth2Auth> event) {
                        if (event.failed()) {
                            cf.completeExceptionally(OidcRecorder.toOidcException(event.cause()));
                        } else {
                            cf.complete(event.result());
                        }
                    }
                });
                auth = (OAuth2Auth)cf.join();
                break;
            }
            catch (Throwable throwable) {
                while (throwable instanceof CompletionException && throwable.getCause() != null) {
                    throwable = throwable.getCause();
                }
                if (throwable instanceof OIDCException) {
                    if (i + 1L < connectionRetryCount) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw (OIDCException)throwable;
                }
                throw new OIDCException(throwable);
            }
        }
        return new TenantConfigContext(auth, oidcConfig);
    }

    protected static OIDCException toOidcException(Throwable cause) {
        String message = "OIDC server is not available at the 'quarkus.oidc.auth-server-url' URL. Please make sure it is correct. Note it has to end with a realm value if you work with Keycloak, for example: 'https://localhost:8180/auth/realms/quarkus'";
        return new OIDCException("OIDC server is not available at the 'quarkus.oidc.auth-server-url' URL. Please make sure it is correct. Note it has to end with a realm value if you work with Keycloak, for example: 'https://localhost:8180/auth/realms/quarkus'", cause);
    }
}

