/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.RefreshToken;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.vertx.http.runtime.security.AuthenticationCompletionException;
import io.quarkus.vertx.http.runtime.security.AuthenticationRedirectException;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.CookieImpl;
import java.net.URI;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class CodeAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    private static final Logger LOG = Logger.getLogger(CodeAuthenticationMechanism.class);
    private static final String STATE_COOKIE_NAME = "q_auth";
    private static final String SESSION_COOKIE_NAME = "q_session";
    private static final String COOKIE_DELIM = "___";

    private static QuarkusSecurityIdentity augmentIdentity(final SecurityIdentity securityIdentity, String accessToken, String refreshToken, RoutingContext context) {
        RefreshToken refreshTokenCredential = new RefreshToken(refreshToken);
        return QuarkusSecurityIdentity.builder().setPrincipal(securityIdentity.getPrincipal()).addCredentials(securityIdentity.getCredentials()).addCredential((Credential)new AccessTokenCredential(accessToken, refreshTokenCredential, context)).addCredential((Credential)refreshTokenCredential).addRoles(securityIdentity.getRoles()).addAttributes(securityIdentity.getAttributes()).addPermissionChecker((Function)new Function<Permission, CompletionStage<Boolean>>(){

            @Override
            public CompletionStage<Boolean> apply(Permission permission) {
                return securityIdentity.checkPermission(permission);
            }
        }).build();
    }

    public CompletionStage<SecurityIdentity> authenticate(final RoutingContext context, IdentityProviderManager identityProviderManager, DefaultTenantConfigResolver resolver) {
        Cookie sessionCookie = context.request().getCookie(SESSION_COOKIE_NAME);
        if (sessionCookie != null) {
            final String[] tokens = sessionCookie.getValue().split(COOKIE_DELIM);
            return this.authenticate(identityProviderManager, new IdTokenCredential(tokens[0], context)).thenCompose(new Function<SecurityIdentity, CompletionStage<SecurityIdentity>>(){

                @Override
                public CompletionStage<SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                    return CompletableFuture.completedFuture(CodeAuthenticationMechanism.augmentIdentity(securityIdentity, tokens[1], tokens[2], context));
                }
            });
        }
        return this.performCodeFlow(identityProviderManager, context, resolver);
    }

    public CompletionStage<ChallengeData> getChallenge(RoutingContext context, DefaultTenantConfigResolver resolver) {
        this.removeCookie(context, SESSION_COOKIE_NAME);
        TenantConfigContext configContext = resolver.resolve(context, false);
        JsonObject params = new JsonObject();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("openid");
        configContext.oidcConfig.getAuthentication().scopes.ifPresent(scopes::addAll);
        params.put("scopes", new JsonArray(scopes));
        URI absoluteUri = URI.create(context.request().absoluteURI());
        String redirectPath = this.getRedirectPath(configContext, absoluteUri);
        String redirectUriParam = this.buildRedirectUri(context, absoluteUri, redirectPath);
        LOG.debugf("Authentication request redirect_uri parameter: %s", (Object)redirectUriParam);
        params.put("redirect_uri", redirectUriParam);
        params.put("state", this.generateState(context, configContext, absoluteUri, redirectPath));
        if (configContext.oidcConfig.authentication.getExtraParams() != null) {
            for (Map.Entry<String, String> entry : configContext.oidcConfig.authentication.getExtraParams().entrySet()) {
                params.put(entry.getKey(), entry.getValue());
            }
        }
        ChallengeData challenge = new ChallengeData(HttpResponseStatus.FOUND.code(), HttpHeaders.LOCATION, configContext.auth.authorizeURL(params));
        return CompletableFuture.completedFuture(challenge);
    }

    private CompletionStage<SecurityIdentity> performCodeFlow(IdentityProviderManager identityProviderManager, RoutingContext context, DefaultTenantConfigResolver resolver) {
        TenantConfigContext configContext = resolver.resolve(context, true);
        JsonObject params = new JsonObject();
        String code = context.request().getParam("code");
        if (code == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<SecurityIdentity> cf = new CompletableFuture<SecurityIdentity>();
        URI absoluteUri = URI.create(context.request().absoluteURI());
        io.vertx.ext.web.Cookie stateCookie = context.getCookie(STATE_COOKIE_NAME);
        if (stateCookie != null) {
            List values = context.queryParam("state");
            if (values.size() != 1) {
                LOG.debug((Object)"State parameter can not be empty or multi-valued");
                cf.completeExceptionally((Throwable)new AuthenticationCompletionException());
                return cf;
            }
            if (!stateCookie.getValue().startsWith((String)values.get(0))) {
                LOG.debug((Object)"State cookie does not match the state parameter");
                cf.completeExceptionally((Throwable)new AuthenticationCompletionException());
                return cf;
            }
            if (context.queryParam("pathChecked").isEmpty()) {
                String[] pair = stateCookie.getValue().split(COOKIE_DELIM);
                if (pair.length == 2) {
                    String extraPath = pair[1];
                    String extraQuery = "?pathChecked=true";
                    if (absoluteUri.getRawQuery() != null) {
                        extraQuery = extraQuery + "&" + absoluteUri.getRawQuery();
                    }
                    String localRedirectUri = this.buildRedirectUri(context, absoluteUri, extraPath + extraQuery);
                    LOG.debugf("Local redirect URI: %s", (Object)localRedirectUri);
                    cf.completeExceptionally((Throwable)new AuthenticationRedirectException(localRedirectUri));
                    return cf;
                }
                this.removeCookie(context, STATE_COOKIE_NAME);
            } else {
                this.removeCookie(context, STATE_COOKIE_NAME);
            }
        } else {
            LOG.debug((Object)"The state cookie is missing after a redirect from IDP");
            cf.completeExceptionally((Throwable)new AuthenticationCompletionException());
            return cf;
        }
        params.put("code", code);
        String redirectPath = this.getRedirectPath(configContext, absoluteUri);
        String redirectUriParam = this.buildRedirectUri(context, absoluteUri, redirectPath);
        LOG.debugf("Token request redirect_uri parameter: %s", (Object)redirectUriParam);
        params.put("redirect_uri", redirectUriParam);
        OidcTenantConfig.Credentials creds = configContext.oidcConfig.getCredentials();
        if (creds.clientSecret.value.isPresent() && creds.clientSecret.method.isPresent() && OidcTenantConfig.Credentials.Secret.Method.POST == creds.clientSecret.method.get()) {
            params.put("client_secret", creds.clientSecret.value.get());
        }
        configContext.auth.authenticate(params, userAsyncResult -> {
            if (userAsyncResult.failed()) {
                if (userAsyncResult.cause() != null) {
                    LOG.debugf("Exception during the code to token exchange: %s", (Object)userAsyncResult.cause().getMessage());
                }
                cf.completeExceptionally((Throwable)new AuthenticationCompletionException(userAsyncResult.cause()));
            } else {
                AccessToken result = (AccessToken)AccessToken.class.cast(userAsyncResult.result());
                this.authenticate(identityProviderManager, new IdTokenCredential(result.opaqueIdToken(), context)).whenCompleteAsync((securityIdentity, throwable) -> {
                    if (throwable != null) {
                        cf.completeExceptionally((Throwable)new AuthenticationCompletionException(throwable));
                    } else {
                        this.processSuccessfulAuthentication(context, configContext, cf, result, (SecurityIdentity)securityIdentity);
                    }
                });
            }
        });
        return cf;
    }

    private void processSuccessfulAuthentication(RoutingContext context, TenantConfigContext configContext, CompletableFuture<SecurityIdentity> cf, AccessToken result, SecurityIdentity securityIdentity) {
        this.removeCookie(context, SESSION_COOKIE_NAME);
        CookieImpl cookie = new CookieImpl(SESSION_COOKIE_NAME, result.opaqueIdToken() + COOKIE_DELIM + result.opaqueAccessToken() + COOKIE_DELIM + result.opaqueRefreshToken());
        cookie.setMaxAge((long)result.idToken().getInteger("exp").intValue());
        cookie.setSecure(context.request().isSSL());
        cookie.setHttpOnly(true);
        if (configContext.oidcConfig.authentication.cookiePath.isPresent()) {
            cookie.setPath(configContext.oidcConfig.authentication.cookiePath.get());
        }
        context.response().addCookie((Cookie)cookie);
        cf.complete((SecurityIdentity)CodeAuthenticationMechanism.augmentIdentity(securityIdentity, result.opaqueAccessToken(), result.opaqueRefreshToken(), context));
    }

    private String getRedirectPath(TenantConfigContext configContext, URI absoluteUri) {
        OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
        return auth.getRedirectPath().isPresent() ? auth.getRedirectPath().get() : absoluteUri.getRawPath();
    }

    private String generateState(RoutingContext context, TenantConfigContext configContext, URI absoluteUri, String redirectPath) {
        String uuid;
        String cookieValue = uuid = UUID.randomUUID().toString();
        OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
        if (auth.isRestorePathAfterRedirect() && !redirectPath.equals(absoluteUri.getRawPath())) {
            cookieValue = cookieValue + COOKIE_DELIM + absoluteUri.getRawPath();
        }
        CookieImpl cookie = new CookieImpl(STATE_COOKIE_NAME, cookieValue);
        cookie.setHttpOnly(true);
        cookie.setSecure(context.request().isSSL());
        cookie.setMaxAge(1800L);
        if (auth.cookiePath.isPresent()) {
            cookie.setPath(auth.getCookiePath().get());
        }
        context.response().addCookie((Cookie)cookie);
        return uuid;
    }

    private String buildRedirectUri(RoutingContext context, URI absoluteUri, String path) {
        return context.request().scheme() + "://" + absoluteUri.getAuthority() + path;
    }

    private Cookie removeCookie(RoutingContext context, String cookieName) {
        return context.response().removeCookie(cookieName, true);
    }
}

