/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdToken;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.runtime.OidcJwtCallerPrincipal;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.jwt.auth.cdi.NullJsonWebToken;
import javax.annotation.Priority;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

@Priority(value=2)
@Alternative
@RequestScoped
public class OidcJsonWebTokenProducer {
    private static final Logger LOG = Logger.getLogger(OidcJsonWebTokenProducer.class);
    @Inject
    SecurityIdentity identity;

    @Produces
    @RequestScoped
    JsonWebToken currentAccessToken() {
        return this.getTokenCredential(AccessTokenCredential.class);
    }

    @Produces
    @IdToken
    @RequestScoped
    JsonWebToken currentIdToken() {
        return this.getTokenCredential(IdTokenCredential.class);
    }

    private JsonWebToken getTokenCredential(Class<? extends TokenCredential> type) {
        if (this.identity.isAnonymous()) {
            return new NullJsonWebToken();
        }
        if (this.identity.getPrincipal() instanceof OidcJwtCallerPrincipal && ((OidcJwtCallerPrincipal)((Object)this.identity.getPrincipal())).getCredential().getClass() == type) {
            return (JsonWebToken)this.identity.getPrincipal();
        }
        TokenCredential credential = (TokenCredential)this.identity.getCredential(type);
        if (credential != null && credential.getToken() != null) {
            JwtClaims jwtClaims;
            if (credential instanceof AccessTokenCredential && ((AccessTokenCredential)credential).isOpaque()) {
                throw new OIDCException("Opaque access token can not be converted to JsonWebToken");
            }
            try {
                jwtClaims = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build().processToClaims(credential.getToken());
            }
            catch (InvalidJwtException e) {
                throw new OIDCException(e);
            }
            jwtClaims.setClaim(Claims.raw_token.name(), (Object)credential.getToken());
            return new OidcJwtCallerPrincipal(jwtClaims, credential);
        }
        String tokenType = type == AccessTokenCredential.class ? "access" : "ID";
        LOG.tracef("Current identity is not associated with an %s token", (Object)tokenType);
        return new NullJsonWebToken();
    }
}

