/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class AbstractJsonObjectResponse {
    private JsonObject json;

    public AbstractJsonObjectResponse() {
    }

    public AbstractJsonObjectResponse(String introspectionJson) {
        this(AbstractJsonObjectResponse.toJsonObject(introspectionJson));
    }

    public AbstractJsonObjectResponse(JsonObject json) {
        this.json = json;
    }

    public String getString(String name) {
        return this.json.getString(name);
    }

    public Boolean getBoolean(String name) {
        return this.json.getBoolean(name);
    }

    public Long getLong(String name) {
        JsonNumber number = this.json.getJsonNumber(name);
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    public JsonArray getArray(String name) {
        return this.json.getJsonArray(name);
    }

    public JsonObject getObject(String name) {
        return this.json.getJsonObject(name);
    }

    public Object get(String name) {
        return this.json.get((Object)name);
    }

    public boolean contains(String propertyName) {
        return this.json.containsKey((Object)propertyName);
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.json.keySet());
    }

    public Set<Map.Entry<String, JsonValue>> getAllProperties() {
        return Collections.unmodifiableSet(this.json.entrySet());
    }

    private static JsonObject toJsonObject(String userInfoJson) {
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(userInfoJson));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }
}

