/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenIntrospection;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.common.runtime.OidcEndpointAccessException;
import io.quarkus.oidc.runtime.JsonWebKeySet;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnItem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.Closeable;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import org.jboss.logging.Logger;

public class OidcProviderClient
implements Closeable {
    private static final Logger LOG = Logger.getLogger(OidcProviderClient.class);
    private static final String AUTHORIZATION_HEADER = String.valueOf(HttpHeaders.AUTHORIZATION);
    private static final String CONTENT_TYPE_HEADER = String.valueOf(HttpHeaders.CONTENT_TYPE);
    private static final String ACCEPT_HEADER = String.valueOf(HttpHeaders.ACCEPT);
    private static final String APPLICATION_X_WWW_FORM_URLENCODED = String.valueOf(HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString());
    private static final String APPLICATION_JSON = "application/json";
    private final WebClient client;
    private final OidcConfigurationMetadata metadata;
    private final OidcTenantConfig oidcConfig;
    private final String clientSecretBasicAuthScheme;
    private final String introspectionBasicAuthScheme;
    private final Key clientJwtKey;

    public OidcProviderClient(WebClient client, OidcConfigurationMetadata metadata, OidcTenantConfig oidcConfig) {
        this.client = client;
        this.metadata = metadata;
        this.oidcConfig = oidcConfig;
        this.clientSecretBasicAuthScheme = OidcCommonUtils.initClientSecretBasicAuth((OidcCommonConfig)oidcConfig);
        this.clientJwtKey = OidcCommonUtils.initClientJwtKey((OidcCommonConfig)oidcConfig);
        this.introspectionBasicAuthScheme = OidcProviderClient.initIntrospectionBasicAuthScheme(oidcConfig);
    }

    private static String initIntrospectionBasicAuthScheme(OidcTenantConfig oidcConfig) {
        if (oidcConfig.getIntrospectionCredentials().name.isPresent() && oidcConfig.getIntrospectionCredentials().secret.isPresent()) {
            return OidcCommonUtils.basicSchemeValue((String)oidcConfig.getIntrospectionCredentials().name.get(), (String)oidcConfig.getIntrospectionCredentials().secret.get());
        }
        return null;
    }

    public OidcConfigurationMetadata getMetadata() {
        return this.metadata;
    }

    public Uni<JsonWebKeySet> getJsonWebKeySet() {
        return this.client.getAbs(this.metadata.getJsonWebKeySetUri()).send().onItem().transform(resp -> this.getJsonWebKeySet((HttpResponse<Buffer>)resp));
    }

    public Uni<UserInfo> getUserInfo(String token) {
        LOG.debugf("Get UserInfo on: %s auth: %s", (Object)this.metadata.getUserInfoUri(), (Object)("Bearer " + token));
        return this.client.getAbs(this.metadata.getUserInfoUri()).putHeader(AUTHORIZATION_HEADER, "Bearer " + token).send().onItem().transform(resp -> this.getUserInfo((HttpResponse<Buffer>)resp));
    }

    public Uni<TokenIntrospection> introspectToken(String token) {
        MultiMap introspectionParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        introspectionParams.add("token", token);
        introspectionParams.add("token_type_hint", "access_token");
        return this.getHttpResponse(this.metadata.getIntrospectionUri(), introspectionParams, true).transform(resp -> this.getTokenIntrospection((HttpResponse<Buffer>)resp));
    }

    private JsonWebKeySet getJsonWebKeySet(HttpResponse<Buffer> resp) {
        if (resp.statusCode() == 200) {
            return new JsonWebKeySet(resp.bodyAsString(StandardCharsets.UTF_8.name()));
        }
        throw new OidcEndpointAccessException(resp.statusCode());
    }

    public OidcTenantConfig getOidcConfig() {
        return this.oidcConfig;
    }

    public Uni<AuthorizationCodeTokens> getAuthorizationCodeTokens(String code, String redirectUri, String codeVerifier) {
        MultiMap codeGrantParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        codeGrantParams.add("grant_type", "authorization_code");
        codeGrantParams.add("code", code);
        codeGrantParams.add("redirect_uri", redirectUri);
        if (codeVerifier != null) {
            codeGrantParams.add("code_verifier", codeVerifier);
        }
        return this.getHttpResponse(this.metadata.getTokenUri(), codeGrantParams, false).transform(resp -> this.getAuthorizationCodeTokens((HttpResponse<Buffer>)resp));
    }

    public Uni<AuthorizationCodeTokens> refreshAuthorizationCodeTokens(String refreshToken) {
        MultiMap refreshGrantParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        refreshGrantParams.add("grant_type", "refresh_token");
        refreshGrantParams.add("refresh_token", refreshToken);
        return this.getHttpResponse(this.metadata.getTokenUri(), refreshGrantParams, false).transform(resp -> this.getAuthorizationCodeTokens((HttpResponse<Buffer>)resp));
    }

    private UniOnItem<HttpResponse<Buffer>> getHttpResponse(String uri, MultiMap formBody, boolean introspect) {
        HttpRequest request = this.client.postAbs(uri);
        request.putHeader(CONTENT_TYPE_HEADER, APPLICATION_X_WWW_FORM_URLENCODED);
        request.putHeader(ACCEPT_HEADER, APPLICATION_JSON);
        if (introspect && this.introspectionBasicAuthScheme != null) {
            request.putHeader(AUTHORIZATION_HEADER, this.introspectionBasicAuthScheme);
            if (this.oidcConfig.clientId.isPresent() && this.oidcConfig.introspectionCredentials.includeClientId) {
                formBody.set("client_id", (String)this.oidcConfig.clientId.get());
            }
        } else if (this.clientSecretBasicAuthScheme != null) {
            request.putHeader(AUTHORIZATION_HEADER, this.clientSecretBasicAuthScheme);
        } else if (this.clientJwtKey != null) {
            String jwt = OidcCommonUtils.signJwtWithKey((OidcCommonConfig)this.oidcConfig, (String)this.metadata.getTokenUri(), (Key)this.clientJwtKey);
            if (OidcCommonUtils.isClientSecretPostJwtAuthRequired((OidcCommonConfig.Credentials)this.oidcConfig.credentials)) {
                formBody.add("client_id", (String)this.oidcConfig.clientId.get());
                formBody.add("client_secret", jwt);
            } else {
                formBody.add("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
                formBody.add("client_assertion", jwt);
            }
        } else if (OidcCommonUtils.isClientSecretPostAuthRequired((OidcCommonConfig.Credentials)this.oidcConfig.credentials)) {
            formBody.add("client_id", (String)this.oidcConfig.clientId.get());
            formBody.add("client_secret", OidcCommonUtils.clientSecret((OidcCommonConfig.Credentials)this.oidcConfig.credentials));
        } else {
            formBody.add("client_id", (String)this.oidcConfig.clientId.get());
        }
        LOG.debugf("Get token on: %s params: %s headers: %s", (Object)this.metadata.getTokenUri(), (Object)formBody, (Object)request.headers());
        Uni response = request.sendBuffer(OidcCommonUtils.encodeForm((MultiMap)formBody)).onFailure(ConnectException.class).retry().atMost((long)this.oidcConfig.connectionRetryCount).onFailure().transform(t -> t.getCause());
        return response.onItem();
    }

    private AuthorizationCodeTokens getAuthorizationCodeTokens(HttpResponse<Buffer> resp) {
        JsonObject json = OidcProviderClient.getJsonObject(resp);
        String idToken = json.getString("id_token");
        String accessToken = json.getString("access_token");
        String refreshToken = json.getString("refresh_token");
        return new AuthorizationCodeTokens(idToken, accessToken, refreshToken);
    }

    private UserInfo getUserInfo(HttpResponse<Buffer> resp) {
        return new UserInfo(OidcProviderClient.getString(resp));
    }

    private TokenIntrospection getTokenIntrospection(HttpResponse<Buffer> resp) {
        return new TokenIntrospection(OidcProviderClient.getString(resp));
    }

    private static JsonObject getJsonObject(HttpResponse<Buffer> resp) {
        if (resp.statusCode() == 200) {
            LOG.debugf("Request succeeded: %s", (Object)resp.bodyAsJsonObject());
            return resp.bodyAsJsonObject();
        }
        throw OidcProviderClient.responseException(resp);
    }

    private static String getString(HttpResponse<Buffer> resp) {
        if (resp.statusCode() == 200) {
            LOG.debugf("Request succeeded: %s", (Object)resp.bodyAsString());
            return resp.bodyAsString();
        }
        throw OidcProviderClient.responseException(resp);
    }

    private static OIDCException responseException(HttpResponse<Buffer> resp) {
        String errorMessage = resp.bodyAsString();
        LOG.debugf("Request has failed: status: %d, error message: %s", resp.statusCode(), (Object)errorMessage);
        throw new OIDCException(errorMessage);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public Key getClientJwtKey() {
        return this.clientJwtKey;
    }
}

