package io.quarkus.oidc.runtime;

import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class AbstractJsonObjectResponse {
    private String jsonString;
    private JsonObject json;

    public AbstractJsonObjectResponse() {
    }

    public AbstractJsonObjectResponse(String jsonString) {
        this(toJsonObject(jsonString));
        this.jsonString = jsonString;
    }

    public AbstractJsonObjectResponse(JsonObject json) {
        this.json = json;
    }

    public String getString(String name) {
        return contains(name) ? json.getString(name) : null;
    }

    public Boolean getBoolean(String name) {
        return contains(name) ? json.getBoolean(name) : null;
    }

    public Long getLong(String name) {
        JsonNumber number = json.getJsonNumber(name);
        return number != null ? number.longValue() : null;
    }

    public JsonArray getArray(String name) {
        return json.getJsonArray(name);
    }

    public JsonObject getObject(String name) {
        return json.getJsonObject(name);
    }

    public JsonObject getJsonObject() {
        return json;
    }

    public Object get(String name) {
        return json.get(name);
    }

    public boolean contains(String propertyName) {
        return json.containsKey(propertyName);
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(json.keySet());
    }

    public Set<Map.Entry<String, JsonValue>> getAllProperties() {
        return Collections.unmodifiableSet(json.entrySet());
    }

    protected String getNonNullJsonString() {
        return jsonString == null ? json.toString() : jsonString;
    }

    private static JsonObject toJsonObject(String userInfoJson) {
        try (JsonReader jsonReader = Json.createReader(new StringReader(userInfoJson))) {
            return jsonReader.readObject();
        }
    }
}
