/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.TenantConfigResolver;
import io.quarkus.oidc.TenantResolver;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.ExecutorRecorder;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.ext.web.RoutingContext;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DefaultTenantConfigResolver {
    private static final Logger LOG = Logger.getLogger(DefaultTenantConfigResolver.class);
    private static final String CURRENT_STATIC_TENANT_ID = "static.tenant.id";
    private static final String CURRENT_STATIC_TENANT_ID_NULL = "static.tenant.id.null";
    private static final String CURRENT_DYNAMIC_TENANT_CONFIG = "dynamic.tenant.config";
    @Inject
    Instance<TenantResolver> tenantResolver;
    @Inject
    Instance<TenantConfigResolver> tenantConfigResolver;
    @Inject
    TenantConfigBean tenantConfigBean;
    @Inject
    Instance<TokenStateManager> tokenStateManager;
    @Inject
    Event<SecurityEvent> securityEvent;
    @Inject
    @ConfigProperty(name="quarkus.http.proxy.enable-forwarded-prefix")
    boolean enableHttpForwardedPrefix;
    private final TenantConfigResolver.TenantConfigRequestContext blockingRequestContext = new TenantConfigResolver.TenantConfigRequestContext(){

        @Override
        public Uni<OidcTenantConfig> runBlocking(final Supplier<OidcTenantConfig> function) {
            return Uni.createFrom().deferred((Supplier)new Supplier<Uni<? extends OidcTenantConfig>>(){

                @Override
                public Uni<OidcTenantConfig> get() {
                    if (BlockingOperationControl.isBlockingAllowed()) {
                        try {
                            OidcTenantConfig result = (OidcTenantConfig)((Object)function.get());
                            return Uni.createFrom().item((Object)result);
                        }
                        catch (Throwable t) {
                            return Uni.createFrom().failure(t);
                        }
                    }
                    return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super OidcTenantConfig>>(){

                        @Override
                        public void accept(final UniEmitter<? super OidcTenantConfig> uniEmitter) {
                            ExecutorRecorder.getCurrent().execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        uniEmitter.complete(function.get());
                                    }
                                    catch (Throwable t) {
                                        uniEmitter.fail(t);
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }
    };
    private volatile boolean securityEventObserved;

    @PostConstruct
    public void verifyResolvers() {
        if (this.tenantConfigResolver.isResolvable() && this.tenantConfigResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantConfigResolver.class + " beans registered");
        }
        if (this.tenantResolver.isResolvable() && this.tenantResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantResolver.class + " beans registered");
        }
        if (this.tokenStateManager.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TokenStateManager.class + " beans registered");
        }
    }

    Uni<OidcTenantConfig> resolveConfig(final RoutingContext context) {
        return this.getDynamicTenantConfig(context).map((Function)new Function<OidcTenantConfig, OidcTenantConfig>(){

            @Override
            public OidcTenantConfig apply(OidcTenantConfig tenantConfig) {
                TenantConfigContext tenant;
                if (tenantConfig == null && (tenant = DefaultTenantConfigResolver.this.getStaticTenantContext(context)) != null) {
                    tenantConfig = tenant.oidcConfig;
                }
                return tenantConfig;
            }
        });
    }

    Uni<TenantConfigContext> resolveContext(final RoutingContext context) {
        return this.getDynamicTenantContext(context).chain((Function)new Function<TenantConfigContext, Uni<? extends TenantConfigContext>>(){

            @Override
            public Uni<? extends TenantConfigContext> apply(TenantConfigContext tenantConfigContext) {
                if (tenantConfigContext != null) {
                    return Uni.createFrom().item((Object)tenantConfigContext);
                }
                TenantConfigContext tenantContext = DefaultTenantConfigResolver.this.getStaticTenantContext(context);
                if (tenantContext != null && !tenantContext.ready) {
                    TenantConfigContext readyTenantContext = DefaultTenantConfigResolver.this.tenantConfigBean.getDynamicTenantsConfig().get(tenantContext.oidcConfig.tenantId.get());
                    if (readyTenantContext == null) {
                        LOG.debugf("Tenant '%s' is not initialized yet, trying to create OIDC connection now", (Object)tenantContext.oidcConfig.tenantId.get());
                        return DefaultTenantConfigResolver.this.tenantConfigBean.getTenantConfigContextFactory().apply(tenantContext.oidcConfig);
                    }
                    tenantContext = readyTenantContext;
                }
                return Uni.createFrom().item((Object)tenantContext);
            }
        });
    }

    private TenantConfigContext getStaticTenantContext(RoutingContext context) {
        TenantConfigContext configContext;
        String tenantId = null;
        if (this.tenantResolver.isResolvable() && (tenantId = (String)context.get(CURRENT_STATIC_TENANT_ID)) == null && context.get(CURRENT_STATIC_TENANT_ID_NULL) == null) {
            tenantId = ((TenantResolver)this.tenantResolver.get()).resolve(context);
            if (tenantId != null) {
                context.put(CURRENT_STATIC_TENANT_ID, (Object)tenantId);
            } else {
                context.put(CURRENT_STATIC_TENANT_ID_NULL, (Object)true);
            }
        }
        TenantConfigContext tenantConfigContext = configContext = tenantId != null ? this.tenantConfigBean.getStaticTenantsConfig().get(tenantId) : null;
        if (configContext == null) {
            if (tenantId != null && !tenantId.isEmpty()) {
                LOG.debugf("Registered TenantResolver has not provided the configuration for tenant '%s', using the default tenant", (Object)tenantId);
            }
            configContext = this.tenantConfigBean.getDefaultTenant();
        }
        return configContext;
    }

    boolean isSecurityEventObserved() {
        return this.securityEventObserved;
    }

    void setSecurityEventObserved(boolean securityEventObserved) {
        this.securityEventObserved = securityEventObserved;
    }

    Event<SecurityEvent> getSecurityEvent() {
        return this.securityEvent;
    }

    TokenStateManager getTokenStateManager() {
        return (TokenStateManager)this.tokenStateManager.get();
    }

    private Uni<OidcTenantConfig> getDynamicTenantConfig(RoutingContext context) {
        if (this.tenantConfigResolver.isResolvable()) {
            Uni oidcConfig = (Uni)context.get(CURRENT_DYNAMIC_TENANT_CONFIG);
            if (oidcConfig == null) {
                oidcConfig = ((TenantConfigResolver)this.tenantConfigResolver.get()).resolve(context, this.blockingRequestContext).memoize().indefinitely();
                if (oidcConfig == null) {
                    oidcConfig = Uni.createFrom().nullItem();
                }
                context.put(CURRENT_DYNAMIC_TENANT_CONFIG, (Object)oidcConfig);
            }
            return oidcConfig;
        }
        return Uni.createFrom().nullItem();
    }

    private Uni<TenantConfigContext> getDynamicTenantContext(RoutingContext context) {
        return this.getDynamicTenantConfig(context).chain((Function)new Function<OidcTenantConfig, Uni<? extends TenantConfigContext>>(){

            @Override
            public Uni<? extends TenantConfigContext> apply(OidcTenantConfig tenantConfig) {
                if (tenantConfig != null) {
                    String tenantId = tenantConfig.getTenantId().orElseThrow(() -> new OIDCException("Tenant configuration must have tenant id"));
                    TenantConfigContext tenantContext = DefaultTenantConfigResolver.this.tenantConfigBean.getDynamicTenantsConfig().get(tenantId);
                    if (tenantContext == null) {
                        return DefaultTenantConfigResolver.this.tenantConfigBean.getTenantConfigContextFactory().apply(tenantConfig);
                    }
                    return Uni.createFrom().item((Object)tenantContext);
                }
                return Uni.createFrom().nullItem();
            }
        });
    }

    boolean isEnableHttpForwardedPrefix() {
        return this.enableHttpForwardedPrefix;
    }
}

