/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.BeanDestroyer;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.smallrye.mutiny.Uni;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.enterprise.context.spi.CreationalContext;

public class TenantConfigBean {
    private final Map<String, TenantConfigContext> staticTenantsConfig;
    private final Map<String, TenantConfigContext> dynamicTenantsConfig;
    private final TenantConfigContext defaultTenant;
    private final Function<OidcTenantConfig, Uni<TenantConfigContext>> tenantConfigContextFactory;

    public TenantConfigBean(Map<String, TenantConfigContext> staticTenantsConfig, Map<String, TenantConfigContext> dynamicTenantsConfig, TenantConfigContext defaultTenant, Function<OidcTenantConfig, Uni<TenantConfigContext>> tenantConfigContextFactory, Executor blockingExecutor) {
        this.staticTenantsConfig = staticTenantsConfig;
        this.dynamicTenantsConfig = dynamicTenantsConfig;
        this.defaultTenant = defaultTenant;
        this.tenantConfigContextFactory = tenantConfigContextFactory;
    }

    public Map<String, TenantConfigContext> getStaticTenantsConfig() {
        return this.staticTenantsConfig;
    }

    public TenantConfigContext getDefaultTenant() {
        return this.defaultTenant;
    }

    public Function<OidcTenantConfig, Uni<TenantConfigContext>> getTenantConfigContextFactory() {
        return this.tenantConfigContextFactory;
    }

    public Map<String, TenantConfigContext> getDynamicTenantsConfig() {
        return this.dynamicTenantsConfig;
    }

    public static class Destroyer
    implements BeanDestroyer<TenantConfigBean> {
        public void destroy(TenantConfigBean instance, CreationalContext<TenantConfigBean> creationalContext, Map<String, Object> params) {
            if (instance.defaultTenant != null) {
                instance.defaultTenant.provider.close();
            }
            for (TenantConfigContext i : instance.staticTenantsConfig.values()) {
                i.provider.close();
            }
            for (TenantConfigContext i : instance.dynamicTenantsConfig.values()) {
                i.provider.close();
            }
        }
    }
}

