/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;

public class OidcConfigPropertySupplier
implements Supplier<String> {
    private String oidcConfigProperty;
    private String defaultValue;

    public OidcConfigPropertySupplier() {
    }

    public OidcConfigPropertySupplier(String oidcConfigProperty) {
        this(oidcConfigProperty, null);
    }

    public OidcConfigPropertySupplier(String oidcConfigProperty, String defaultValue) {
        this.oidcConfigProperty = oidcConfigProperty;
        this.defaultValue = defaultValue;
    }

    @Override
    public String get() {
        if (this.defaultValue != null) {
            return ConfigProvider.getConfig().getOptionalValue(this.oidcConfigProperty, String.class).orElse(this.defaultValue);
        }
        return (String)ConfigProvider.getConfig().getValue(this.oidcConfigProperty, String.class);
    }

    public String getOidcConfigProperty() {
        return this.oidcConfigProperty;
    }

    public void setOidcConfigProperty(String oidcConfigProperty) {
        this.oidcConfigProperty = oidcConfigProperty;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

