/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenAutoRefreshException;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.smallrye.jwt.build.Jwt;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.CookieImpl;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.jose4j.jwt.consumer.InvalidJwtException;

public class CodeAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    static final String AMP = "&";
    static final String EQ = "=";
    static final String UNDERSCORE = "_";
    static final String COOKIE_DELIM = "|";
    static final Pattern COOKIE_PATTERN = Pattern.compile("\\|");
    static final String SESSION_MAX_AGE_PARAM = "session-max-age";
    static final Uni<Void> VOID_UNI = Uni.createFrom().voidItem();
    static final Integer MAX_COOKIE_VALUE_LENGTH = 4096;
    private static final Logger LOG = Logger.getLogger(CodeAuthenticationMechanism.class);
    private final BlockingTaskRunner<String> createTokenStateRequestContext = new BlockingTaskRunner();
    private final BlockingTaskRunner<AuthorizationCodeTokens> getTokenStateRequestContext = new BlockingTaskRunner();

    public Uni<SecurityIdentity> authenticate(final RoutingContext context, final IdentityProviderManager identityProviderManager, OidcTenantConfig oidcTenantConfig) {
        final Cookie sessionCookie = context.request().getCookie(CodeAuthenticationMechanism.getSessionCookieName(oidcTenantConfig));
        if (sessionCookie != null) {
            context.put("q_session", (Object)sessionCookie.getName());
            Uni<TenantConfigContext> resolvedContext = this.resolver.resolveContext(context);
            return resolvedContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(TenantConfigContext tenantContext) {
                    return CodeAuthenticationMechanism.this.reAuthenticate(sessionCookie, context, identityProviderManager, tenantContext);
                }
            });
        }
        final String code = context.request().getParam("code");
        if (code == null) {
            return Uni.createFrom().optional(Optional.empty());
        }
        Uni<TenantConfigContext> resolvedContext = this.resolver.resolveContext(context);
        return resolvedContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(TenantConfigContext tenantContext) {
                return CodeAuthenticationMechanism.this.performCodeFlow(identityProviderManager, context, tenantContext, code);
            }
        });
    }

    private Uni<SecurityIdentity> reAuthenticate(Cookie sessionCookie, final RoutingContext context, final IdentityProviderManager identityProviderManager, final TenantConfigContext configContext) {
        return this.resolver.getTokenStateManager().getTokens(context, configContext.oidcConfig, sessionCookie.getValue(), this.getTokenStateRequestContext).chain((Function)new Function<AuthorizationCodeTokens, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<? extends SecurityIdentity> apply(final AuthorizationCodeTokens session) {
                context.put("access_token", (Object)session.getAccessToken());
                context.put(AuthorizationCodeTokens.class.getName(), (Object)session);
                return CodeAuthenticationMechanism.this.authenticate(identityProviderManager, context, new IdTokenCredential(session.getIdToken(), configContext.oidcConfig.authentication.isIdTokenRequired().orElse(true) == false)).call(new Function<SecurityIdentity, Uni<?>>(){

                    @Override
                    public Uni<Void> apply(SecurityIdentity identity) {
                        if (CodeAuthenticationMechanism.this.isLogout(context, configContext)) {
                            CodeAuthenticationMechanism.this.fireEvent(SecurityEvent.Type.OIDC_LOGOUT_RP_INITIATED, identity);
                            return CodeAuthenticationMechanism.this.buildLogoutRedirectUriUni(context, configContext, session.getIdToken());
                        }
                        return VOID_UNI;
                    }
                }).onFailure().recoverWithUni((Function)new Function<Throwable, Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<? extends SecurityIdentity> apply(Throwable t) {
                        if (t instanceof AuthenticationRedirectException) {
                            throw (AuthenticationRedirectException)t;
                        }
                        if (!(t instanceof TokenAutoRefreshException)) {
                            boolean expired;
                            boolean bl = expired = t.getCause() instanceof InvalidJwtException && ((InvalidJwtException)t.getCause()).hasErrorCode(1);
                            if (!expired) {
                                LOG.debugf("Authentication failure: %s", (Object)t.getCause());
                                throw new AuthenticationCompletionException(t.getCause());
                            }
                            if (!configContext.oidcConfig.token.refreshExpired) {
                                LOG.debug((Object)"Token has expired, token refresh is not allowed");
                                throw new AuthenticationCompletionException(t.getCause());
                            }
                            LOG.debug((Object)"Token has expired, trying to refresh it");
                            return CodeAuthenticationMechanism.this.refreshSecurityIdentity(configContext, session.getRefreshToken(), context, identityProviderManager, false, null);
                        }
                        return CodeAuthenticationMechanism.this.refreshSecurityIdentity(configContext, session.getRefreshToken(), context, identityProviderManager, true, ((TokenAutoRefreshException)t).getSecurityIdentity());
                    }
                });
            }
        });
    }

    private boolean isJavaScript(RoutingContext context) {
        String value = context.request().getHeader("X-Requested-With");
        return "JavaScript".equals(value) || "XMLHttpRequest".equals(value);
    }

    private boolean shouldAutoRedirect(TenantConfigContext configContext, RoutingContext context) {
        return this.isJavaScript(context) ? configContext.oidcConfig.authentication.javaScriptAutoRedirect : true;
    }

    public Uni<ChallengeData> getChallenge(final RoutingContext context) {
        Uni<TenantConfigContext> tenantContext = this.resolver.resolveContext(context);
        return tenantContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends ChallengeData>>(){

            @Override
            public Uni<ChallengeData> apply(TenantConfigContext tenantContext) {
                return CodeAuthenticationMechanism.this.getChallengeInternal(context, tenantContext);
            }
        });
    }

    public Uni<ChallengeData> getChallengeInternal(final RoutingContext context, final TenantConfigContext configContext) {
        return this.removeSessionCookie(context, configContext.oidcConfig).chain((Function)new Function<Void, Uni<? extends ChallengeData>>(){

            @Override
            public Uni<ChallengeData> apply(Void t) {
                if (!CodeAuthenticationMechanism.this.shouldAutoRedirect(configContext, context)) {
                    return Uni.createFrom().item((Object)new ChallengeData(499, (CharSequence)"WWW-Authenticate", "OIDC"));
                }
                StringBuilder codeFlowParams = new StringBuilder(168);
                codeFlowParams.append("response_type").append(CodeAuthenticationMechanism.EQ).append("code");
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("client_id").append(CodeAuthenticationMechanism.EQ).append(OidcCommonUtils.urlEncode((String)((String)configContext.oidcConfig.clientId.get())));
                List oidcConfigScopes = configContext.oidcConfig.getAuthentication().scopes.isPresent() ? configContext.oidcConfig.getAuthentication().scopes.get() : Collections.emptyList();
                ArrayList<String> scopes = new ArrayList<String>(oidcConfigScopes.size() + 1);
                scopes.add("openid");
                scopes.addAll(oidcConfigScopes);
                configContext.oidcConfig.getAuthentication().scopes.ifPresent(scopes::addAll);
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("scope").append(CodeAuthenticationMechanism.EQ).append(OidcCommonUtils.urlEncode((String)String.join((CharSequence)" ", scopes)));
                String redirectPath = CodeAuthenticationMechanism.this.getRedirectPath(configContext, context);
                String redirectUriParam = CodeAuthenticationMechanism.this.buildUri(context, CodeAuthenticationMechanism.this.isForceHttps(configContext), redirectPath);
                LOG.debugf("Authentication request redirect_uri parameter: %s", (Object)redirectUriParam);
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("redirect_uri").append(CodeAuthenticationMechanism.EQ).append(OidcCommonUtils.urlEncode((String)redirectUriParam));
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("state").append(CodeAuthenticationMechanism.EQ).append(CodeAuthenticationMechanism.this.generateCodeFlowState(context, configContext, redirectPath));
                CodeAuthenticationMechanism.addExtraParamsToUri(codeFlowParams, configContext.oidcConfig.authentication.getExtraParams());
                String authorizationURL = configContext.provider.getMetadata().getAuthorizationUri() + "?" + codeFlowParams.toString();
                return Uni.createFrom().item((Object)new ChallengeData(HttpResponseStatus.FOUND.code(), HttpHeaders.LOCATION, authorizationURL));
            }
        });
    }

    private Uni<SecurityIdentity> performCodeFlow(final IdentityProviderManager identityProviderManager, final RoutingContext context, final TenantConfigContext configContext, String code) {
        Cookie stateCookie = context.getCookie(CodeAuthenticationMechanism.getStateCookieName(configContext));
        String userPath = null;
        String userQuery = null;
        if (stateCookie != null) {
            List values = context.queryParam("state");
            if (values.size() != 1) {
                LOG.debug((Object)"State parameter can not be empty or multi-valued");
                return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
            }
            if (!stateCookie.getValue().startsWith((String)values.get(0))) {
                LOG.debug((Object)"State cookie value does not match the state query parameter value");
                return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
            }
            String[] pair = COOKIE_PATTERN.split(stateCookie.getValue());
            if (pair.length == 2) {
                int userQueryIndex = pair[1].indexOf("?");
                if (userQueryIndex >= 0) {
                    userPath = pair[1].substring(0, userQueryIndex);
                    if (userQueryIndex + 1 < pair[1].length()) {
                        userQuery = pair[1].substring(userQueryIndex + 1);
                    }
                } else {
                    userPath = pair[1];
                }
            }
        } else {
            LOG.debug((Object)"The state cookie is missing after a redirect from IDP, authentication has failed");
            return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
        }
        OidcUtils.removeCookie(context, configContext.oidcConfig, stateCookie.getName());
        final String finalUserPath = userPath;
        final String finalUserQuery = userQuery;
        Uni<AuthorizationCodeTokens> codeFlowTokensUni = this.getCodeFlowTokensUni(context, configContext, code);
        return codeFlowTokensUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<AuthorizationCodeTokens, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(final AuthorizationCodeTokens tokens, Throwable tOuter) {
                if (tOuter != null) {
                    LOG.debugf("Exception during the code to token exchange: %s", (Object)tOuter.getMessage());
                    return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException(tOuter));
                }
                boolean internalIdToken = false;
                if (tokens.getIdToken() == null) {
                    if (configContext.oidcConfig.authentication.isIdTokenRequired().orElse(true).booleanValue()) {
                        return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException("ID Token is not available"));
                    }
                    tokens.setIdToken(CodeAuthenticationMechanism.this.generateInternalIdToken(configContext.oidcConfig));
                    internalIdToken = true;
                }
                context.put("new_authentication", (Object)Boolean.TRUE);
                context.put("access_token", (Object)tokens.getAccessToken());
                context.put(AuthorizationCodeTokens.class.getName(), (Object)tokens);
                return CodeAuthenticationMechanism.this.authenticate(identityProviderManager, context, new IdTokenCredential(tokens.getIdToken(), internalIdToken)).call(new Function<SecurityIdentity, Uni<?>>(){

                    @Override
                    public Uni<Void> apply(SecurityIdentity identity) {
                        return CodeAuthenticationMechanism.this.processSuccessfulAuthentication(context, configContext, tokens, identity);
                    }
                }).map((Function)new Function<SecurityIdentity, SecurityIdentity>(){

                    @Override
                    public SecurityIdentity apply(SecurityIdentity identity) {
                        boolean removeRedirectParams = configContext.oidcConfig.authentication.isRemoveRedirectParameters();
                        if (removeRedirectParams || finalUserPath != null || finalUserQuery != null) {
                            URI absoluteUri = URI.create(context.request().absoluteURI());
                            StringBuilder finalUriWithoutQuery = new StringBuilder(CodeAuthenticationMechanism.this.buildUri(context, CodeAuthenticationMechanism.this.isForceHttps(configContext), absoluteUri.getAuthority(), finalUserPath != null ? finalUserPath : absoluteUri.getRawPath()));
                            if (!removeRedirectParams) {
                                finalUriWithoutQuery.append('?').append(absoluteUri.getRawQuery());
                            }
                            if (finalUserQuery != null) {
                                finalUriWithoutQuery.append(!removeRedirectParams ? "" : "?");
                                finalUriWithoutQuery.append(finalUserQuery);
                            }
                            String finalRedirectUri = finalUriWithoutQuery.toString();
                            LOG.debugf("Final redirect URI: %s", (Object)finalRedirectUri);
                            throw new AuthenticationRedirectException(finalRedirectUri);
                        }
                        return identity;
                    }
                }).onFailure().transform((Function)new Function<Throwable, Throwable>(){

                    @Override
                    public Throwable apply(Throwable tInner) {
                        if (tInner instanceof AuthenticationRedirectException) {
                            return tInner;
                        }
                        return new AuthenticationCompletionException(tInner);
                    }
                });
            }
        });
    }

    private String generateInternalIdToken(OidcTenantConfig oidcConfig) {
        return Jwt.claims().sign(KeyUtils.createSecretKeyFromSecret((String)((String)oidcConfig.credentials.secret.get())));
    }

    private Uni<Void> processSuccessfulAuthentication(final RoutingContext context, final TenantConfigContext configContext, final AuthorizationCodeTokens tokens, final SecurityIdentity securityIdentity) {
        return this.removeSessionCookie(context, configContext.oidcConfig).chain((Function)new Function<Void, Uni<? extends Void>>(){

            @Override
            public Uni<? extends Void> apply(Void t) {
                JsonObject idToken = OidcUtils.decodeJwtContent(tokens.getIdToken());
                if (!idToken.containsKey("exp") || !idToken.containsKey("iat")) {
                    LOG.debug((Object)"ID Token is required to contain 'exp' and 'iat' claims");
                    throw new AuthenticationCompletionException();
                }
                long maxAge = idToken.getLong("exp") - idToken.getLong("iat");
                if (configContext.oidcConfig.token.lifespanGrace.isPresent()) {
                    maxAge += (long)configContext.oidcConfig.token.lifespanGrace.getAsInt();
                }
                if (configContext.oidcConfig.token.refreshExpired) {
                    maxAge += configContext.oidcConfig.authentication.sessionAgeExtension.getSeconds();
                }
                final long sessionMaxAge = maxAge;
                context.put(CodeAuthenticationMechanism.SESSION_MAX_AGE_PARAM, (Object)maxAge);
                return CodeAuthenticationMechanism.this.resolver.getTokenStateManager().createTokenState(context, configContext.oidcConfig, tokens, CodeAuthenticationMechanism.this.createTokenStateRequestContext).map((Function)new Function<String, Void>(){

                    @Override
                    public Void apply(String cookieValue) {
                        String sessionCookie = CodeAuthenticationMechanism.createCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getSessionCookieName(configContext.oidcConfig), cookieValue, sessionMaxAge).getValue();
                        if (sessionCookie.length() >= MAX_COOKIE_VALUE_LENGTH) {
                            LOG.warnf("Session cookie length for the tenant %s is equal or greater than %d bytes. Browsers may ignore this cookie which will cause a new challenge for the authenticated users. Recommendations: 1. Set 'quarkus.oidc.token-state-manager.split-tokens=true' to have the ID, access and refresh tokens stored in separate cookies. 2. Set 'quarkus.oidc.token-state-manager.strategy=id-refresh-tokens' if you do not need to use the access token as a source of roles or to request UserInfo or propagate it to the downstream services. 3. Register a custom 'quarkus.oidc.TokenStateManager' CDI bean with the alternative priority set to 1.", (Object)configContext.oidcConfig.tenantId.get(), (Object)MAX_COOKIE_VALUE_LENGTH);
                        }
                        CodeAuthenticationMechanism.this.fireEvent(SecurityEvent.Type.OIDC_LOGIN, securityIdentity);
                        return null;
                    }
                });
            }
        });
    }

    private void fireEvent(SecurityEvent.Type eventType, SecurityIdentity securityIdentity) {
        if (this.resolver.isSecurityEventObserved()) {
            this.resolver.getSecurityEvent().fire((Object)new SecurityEvent(eventType, securityIdentity));
        }
    }

    private String getRedirectPath(TenantConfigContext configContext, RoutingContext context) {
        OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
        return auth.getRedirectPath().isPresent() ? auth.getRedirectPath().get() : context.request().path();
    }

    private String generateCodeFlowState(RoutingContext context, TenantConfigContext configContext, String redirectPath) {
        boolean restorePath;
        String uuid = UUID.randomUUID().toString();
        Object cookieValue = uuid;
        OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
        boolean bl = restorePath = auth.isRestorePathAfterRedirect() || !auth.redirectPath.isPresent();
        if (restorePath) {
            Object requestPath;
            String requestQuery = context.request().query();
            Object object = requestPath = !redirectPath.equals(context.request().path()) || requestQuery != null ? context.request().path() : "";
            if (requestQuery != null) {
                requestPath = (String)requestPath + "?" + requestQuery;
            }
            if (!((String)requestPath).isEmpty()) {
                cookieValue = (String)cookieValue + COOKIE_DELIM + (String)requestPath;
            }
        }
        CodeAuthenticationMechanism.createCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getStateCookieName(configContext), (String)cookieValue, 1800L);
        return uuid;
    }

    private String generatePostLogoutState(RoutingContext context, TenantConfigContext configContext) {
        OidcUtils.removeCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getPostLogoutCookieName(configContext));
        return CodeAuthenticationMechanism.createCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getPostLogoutCookieName(configContext), UUID.randomUUID().toString(), 1800L).getValue();
    }

    static ServerCookie createCookie(RoutingContext context, OidcTenantConfig oidcConfig, String name, String value, long maxAge) {
        CookieImpl cookie = new CookieImpl(name, value);
        cookie.setHttpOnly(true);
        cookie.setSecure(oidcConfig.authentication.cookieForceSecure || context.request().isSSL());
        cookie.setMaxAge(maxAge);
        LOG.debugf(name + " cookie 'max-age' parameter is set to %d", maxAge);
        OidcTenantConfig.Authentication auth = oidcConfig.getAuthentication();
        OidcUtils.setCookiePath(context, auth, (ServerCookie)cookie);
        if (auth.cookieDomain.isPresent()) {
            cookie.setDomain(auth.getCookieDomain().get());
        }
        context.response().addCookie((Cookie)cookie);
        return cookie;
    }

    private String buildUri(RoutingContext context, boolean forceHttps, String path) {
        String authority = URI.create(context.request().absoluteURI()).getAuthority();
        return this.buildUri(context, forceHttps, authority, path);
    }

    private String buildUri(RoutingContext context, boolean forceHttps, String authority, String path) {
        String forwardedPrefixHeader;
        String scheme = forceHttps ? "https" : context.request().scheme();
        String forwardedPrefix = "";
        if (this.resolver.isEnableHttpForwardedPrefix() && (forwardedPrefixHeader = context.request().getHeader("X-Forwarded-Prefix")) != null && !forwardedPrefixHeader.equals("/") && !forwardedPrefixHeader.equals("//") && (forwardedPrefix = forwardedPrefixHeader).endsWith("/")) {
            forwardedPrefix = forwardedPrefix.substring(0, forwardedPrefix.length() - 1);
        }
        return scheme + "://" + authority + forwardedPrefix + path;
    }

    private boolean isLogout(RoutingContext context, TenantConfigContext configContext) {
        Optional<String> logoutPath = configContext.oidcConfig.logout.path;
        if (logoutPath.isPresent()) {
            return context.request().absoluteURI().equals(this.buildUri(context, false, logoutPath.get()));
        }
        return false;
    }

    private Uni<SecurityIdentity> refreshSecurityIdentity(final TenantConfigContext configContext, String refreshToken, final RoutingContext context, final IdentityProviderManager identityProviderManager, final boolean autoRefresh, SecurityIdentity fallback) {
        Uni<AuthorizationCodeTokens> refreshedTokensUni = this.refreshTokensUni(configContext, refreshToken);
        return refreshedTokensUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<AuthorizationCodeTokens, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(final AuthorizationCodeTokens tokens, Throwable t) {
                if (t != null) {
                    LOG.debugf("ID token refresh has failed: %s", (Object)t.getMessage());
                    if (autoRefresh) {
                        LOG.debug((Object)"Using the current SecurityIdentity since the ID token is still valid");
                        return Uni.createFrom().item((Object)((TokenAutoRefreshException)t).getSecurityIdentity());
                    }
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
                }
                context.put("access_token", (Object)tokens.getAccessToken());
                context.put(AuthorizationCodeTokens.class.getName(), (Object)tokens);
                context.put("refresh_token_grant_response", (Object)Boolean.TRUE);
                return CodeAuthenticationMechanism.this.authenticate(identityProviderManager, context, new IdTokenCredential(tokens.getIdToken())).call(new Function<SecurityIdentity, Uni<?>>(){

                    @Override
                    public Uni<Void> apply(SecurityIdentity identity) {
                        return CodeAuthenticationMechanism.this.processSuccessfulAuthentication(context, configContext, tokens, identity);
                    }
                }).map((Function)new Function<SecurityIdentity, SecurityIdentity>(){

                    @Override
                    public SecurityIdentity apply(SecurityIdentity identity) {
                        CodeAuthenticationMechanism.this.fireEvent(autoRefresh ? SecurityEvent.Type.OIDC_SESSION_REFRESHED : SecurityEvent.Type.OIDC_SESSION_EXPIRED_AND_REFRESHED, identity);
                        return identity;
                    }
                }).onFailure().transform((Function)new Function<Throwable, Throwable>(){

                    @Override
                    public Throwable apply(Throwable tInner) {
                        return new AuthenticationFailedException(tInner);
                    }
                });
            }
        });
    }

    private Uni<AuthorizationCodeTokens> refreshTokensUni(TenantConfigContext configContext, String refreshToken) {
        return configContext.provider.refreshTokens(refreshToken);
    }

    private Uni<AuthorizationCodeTokens> getCodeFlowTokensUni(RoutingContext context, TenantConfigContext configContext, String code) {
        String redirectPath = this.getRedirectPath(configContext, context);
        String redirectUriParam = this.buildUri(context, this.isForceHttps(configContext), redirectPath);
        LOG.debugf("Token request redirect_uri parameter: %s", (Object)redirectUriParam);
        return configContext.provider.getCodeFlowTokens(code, redirectUriParam);
    }

    private String buildLogoutRedirectUri(TenantConfigContext configContext, String idToken, RoutingContext context) {
        String logoutPath = configContext.provider.getMetadata().getEndSessionUri();
        StringBuilder logoutUri = new StringBuilder(logoutPath);
        if (idToken != null || configContext.oidcConfig.logout.postLogoutPath.isPresent()) {
            logoutUri.append("?");
        }
        if (idToken != null) {
            logoutUri.append("id_token_hint").append(EQ).append(idToken);
        }
        if (configContext.oidcConfig.logout.postLogoutPath.isPresent()) {
            logoutUri.append(AMP).append(configContext.oidcConfig.logout.getPostLogoutUriParam()).append(EQ).append(this.buildUri(context, this.isForceHttps(configContext), configContext.oidcConfig.logout.postLogoutPath.get()));
            logoutUri.append(AMP).append("state").append(EQ).append(this.generatePostLogoutState(context, configContext));
        }
        CodeAuthenticationMechanism.addExtraParamsToUri(logoutUri, configContext.oidcConfig.logout.extraParams);
        return logoutUri.toString();
    }

    private static void addExtraParamsToUri(StringBuilder builder, Map<String, String> extraParams) {
        if (extraParams != null) {
            for (Map.Entry<String, String> entry : extraParams.entrySet()) {
                builder.append(AMP).append(entry.getKey()).append(EQ).append(OidcCommonUtils.urlEncode((String)entry.getValue()));
            }
        }
    }

    private boolean isForceHttps(TenantConfigContext configContext) {
        return configContext.oidcConfig.authentication.forceRedirectHttpsScheme;
    }

    private Uni<Void> buildLogoutRedirectUriUni(final RoutingContext context, final TenantConfigContext configContext, final String idToken) {
        return this.removeSessionCookie(context, configContext.oidcConfig).map((Function)new Function<Void, Void>(){

            @Override
            public Void apply(Void t) {
                throw new AuthenticationRedirectException(CodeAuthenticationMechanism.this.buildLogoutRedirectUri(configContext, idToken, context));
            }
        });
    }

    private static String getStateCookieName(TenantConfigContext configContext) {
        return "q_auth" + CodeAuthenticationMechanism.getCookieSuffix(configContext.oidcConfig);
    }

    private static String getPostLogoutCookieName(TenantConfigContext configContext) {
        return "q_post_logout" + CodeAuthenticationMechanism.getCookieSuffix(configContext.oidcConfig);
    }

    private static String getSessionCookieName(OidcTenantConfig oidcConfig) {
        return "q_session" + CodeAuthenticationMechanism.getCookieSuffix(oidcConfig);
    }

    private Uni<Void> removeSessionCookie(RoutingContext context, OidcTenantConfig oidcConfig) {
        String cookieName = CodeAuthenticationMechanism.getSessionCookieName(oidcConfig);
        return OidcUtils.removeSessionCookie(context, oidcConfig, cookieName, this.resolver.getTokenStateManager());
    }

    static String getCookieSuffix(OidcTenantConfig oidcConfig) {
        String tenantId = oidcConfig.tenantId.get();
        boolean cookieSuffixConfigured = oidcConfig.authentication.cookieSuffix.isPresent();
        String tenantIdSuffix = cookieSuffixConfigured || !"Default".equals(tenantId) ? UNDERSCORE + tenantId : "";
        return cookieSuffixConfigured ? tenantIdSuffix + UNDERSCORE + oidcConfig.authentication.cookieSuffix.get() : tenantIdSuffix;
    }
}

