/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.OidcProvider;
import io.quarkus.oidc.runtime.OidcUtils;
import io.smallrye.jwt.util.KeyUtils;
import java.nio.charset.StandardCharsets;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;

public class TenantConfigContext {
    private static final Logger LOG = Logger.getLogger(TenantConfigContext.class);
    final OidcProvider provider;
    final OidcTenantConfig oidcConfig;
    private final SecretKey pkceSecretKey;
    private final SecretKey tokenEncSecretKey;
    final boolean ready;

    public TenantConfigContext(OidcProvider client, OidcTenantConfig config) {
        this(client, config, true);
    }

    public TenantConfigContext(OidcProvider client, OidcTenantConfig config, boolean ready) {
        this.provider = client;
        this.oidcConfig = config;
        this.ready = ready;
        boolean isService = OidcUtils.isServiceApp(config);
        this.pkceSecretKey = !isService && this.provider != null && this.provider.client != null ? TenantConfigContext.createPkceSecretKey(config) : null;
        this.tokenEncSecretKey = !isService && this.provider != null && this.provider.client != null ? TenantConfigContext.createTokenEncSecretKey(config) : null;
    }

    private static SecretKey createPkceSecretKey(OidcTenantConfig config) {
        if (config.authentication.pkceRequired.orElse(false).booleanValue()) {
            String pkceSecret = config.authentication.pkceSecret.orElse(OidcCommonUtils.clientSecret((OidcCommonConfig.Credentials)config.credentials));
            if (pkceSecret == null) {
                throw new RuntimeException("Secret key for encrypting PKCE code verifier is missing");
            }
            if (pkceSecret.length() != 32) {
                throw new RuntimeException("Secret key for encrypting PKCE code verifier must be 32 characters long");
            }
            return KeyUtils.createSecretKeyFromSecret((String)pkceSecret);
        }
        return null;
    }

    private static SecretKey createTokenEncSecretKey(OidcTenantConfig config) {
        if (config.tokenStateManager.encryptionRequired) {
            String encSecret = config.tokenStateManager.encryptionSecret.orElse(OidcCommonUtils.clientSecret((OidcCommonConfig.Credentials)config.credentials));
            if (encSecret == null) {
                encSecret = OidcCommonUtils.jwtSecret((OidcCommonConfig.Credentials)config.credentials);
            }
            try {
                if (encSecret == null) {
                    LOG.warn((Object)"Secret key for encrypting tokens is missing, auto-generating it");
                    KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                    keyGenerator.init(256);
                    return keyGenerator.generateKey();
                }
                byte[] secretBytes = encSecret.getBytes(StandardCharsets.UTF_8);
                if (secretBytes.length < 32) {
                    LOG.warn((Object)"Secret key for encrypting tokens should be 32 characters long");
                }
                return new SecretKeySpec(OidcUtils.getSha256Digest(secretBytes), "AES");
            }
            catch (Exception ex) {
                throw new OIDCException(ex);
            }
        }
        return null;
    }

    public OidcTenantConfig getOidcTenantConfig() {
        return this.oidcConfig;
    }

    public SecretKey getPkceSecretKey() {
        return this.pkceSecretKey;
    }

    public SecretKey getTokenEncSecretKey() {
        return this.tokenEncSecretKey;
    }
}

