/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.BackChannelLogoutTokenCache;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.jwt.consumer.InvalidJwtException;

public class BackChannelLogoutHandler {
    private static final Logger LOG = Logger.getLogger(BackChannelLogoutHandler.class);
    private static final String SLASH = "/";
    @Inject
    DefaultTenantConfigResolver resolver;
    private final OidcConfig oidcConfig;

    public BackChannelLogoutHandler(OidcConfig oidcConfig) {
        this.oidcConfig = oidcConfig;
    }

    public void setup(@Observes Router router) {
        this.addRoute(router, new io.quarkus.oidc.OidcTenantConfig(OidcConfig.getDefaultTenant(this.oidcConfig), "Default"));
        for (Map.Entry<String, OidcTenantConfig> nameToOidcTenantConfig : this.oidcConfig.namedTenants().entrySet()) {
            this.addRoute(router, new io.quarkus.oidc.OidcTenantConfig(nameToOidcTenantConfig.getValue(), nameToOidcTenantConfig.getKey()));
        }
    }

    private void addRoute(Router router, io.quarkus.oidc.OidcTenantConfig oidcTenantConfig) {
        if (oidcTenantConfig.isTenantEnabled() && oidcTenantConfig.logout.backchannel.path.isPresent()) {
            router.route(oidcTenantConfig.logout.backchannel.path.get()).handler((Handler)new RouteHandler(oidcTenantConfig));
        }
    }

    private String getRootPath() {
        String rootPath = OidcCommonUtils.prependSlash((String)this.resolver.getRootPath());
        if (rootPath.length() > 1 && rootPath.endsWith(SLASH)) {
            rootPath = rootPath.substring(rootPath.length() - 1);
        }
        return SLASH.equals(rootPath) ? "" : rootPath;
    }

    class RouteHandler
    implements Handler<RoutingContext> {
        private final io.quarkus.oidc.OidcTenantConfig oidcTenantConfig;

        RouteHandler(io.quarkus.oidc.OidcTenantConfig oidcTenantConfig) {
            this.oidcTenantConfig = oidcTenantConfig;
        }

        public void handle(final RoutingContext context) {
            LOG.debugf("Back channel logout request for the tenant %s received", (Object)this.oidcTenantConfig.getTenantId().get());
            String requestPath = context.request().path();
            final TenantConfigContext tenantContext = this.getTenantConfigContext(requestPath);
            if (tenantContext == null) {
                LOG.errorf("Tenant configuration for the tenant %s is not available or does not match the backchannel logout path %s", (Object)this.oidcTenantConfig.getTenantId().get(), (Object)requestPath);
                context.response().setStatusCode(400);
                context.response().end();
                return;
            }
            if (OidcUtils.isFormUrlEncodedRequest(context)) {
                OidcUtils.getFormUrlEncodedData(context).subscribe().with((Consumer)new Consumer<MultiMap>(){

                    @Override
                    public void accept(MultiMap form) {
                        String encodedLogoutToken = form.get("logout_token");
                        if (encodedLogoutToken == null) {
                            LOG.debug((Object)"Back channel logout token is missing");
                            context.response().setStatusCode(400);
                        } else {
                            try {
                                TokenVerificationResult result = tenantContext.provider().verifyLogoutJwtToken(encodedLogoutToken);
                                if (RouteHandler.this.verifyLogoutTokenClaims(result)) {
                                    String key = result.localVerificationResult.getString(RouteHandler.this.oidcTenantConfig.logout.backchannel.logoutTokenKey);
                                    BackChannelLogoutTokenCache tokens = BackChannelLogoutHandler.this.resolver.getBackChannelLogoutTokens().get(RouteHandler.this.oidcTenantConfig.tenantId.get());
                                    if (tokens == null) {
                                        tokens = new BackChannelLogoutTokenCache(RouteHandler.this.oidcTenantConfig, context.vertx());
                                        BackChannelLogoutHandler.this.resolver.getBackChannelLogoutTokens().put(RouteHandler.this.oidcTenantConfig.tenantId.get(), tokens);
                                    }
                                    tokens.addTokenVerification(key, result);
                                    if (BackChannelLogoutHandler.this.resolver.isSecurityEventObserved()) {
                                        SecurityEventHelper.fire(BackChannelLogoutHandler.this.resolver.getSecurityEvent(), (io.quarkus.security.spi.runtime.SecurityEvent)new SecurityEvent(SecurityEvent.Type.OIDC_BACKCHANNEL_LOGOUT_INITIATED, Map.of("logout_token", result)));
                                    }
                                    context.response().setStatusCode(200);
                                } else {
                                    context.response().setStatusCode(400);
                                }
                            }
                            catch (InvalidJwtException e) {
                                LOG.debug((Object)"Back channel logout token is invalid");
                                context.response().setStatusCode(400);
                            }
                        }
                        context.response().end();
                    }
                });
            } else {
                LOG.debug((Object)("HTTP POST and " + HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString() + " content type must be used with the Back channel logout request"));
                context.response().setStatusCode(400);
                context.response().end();
            }
        }

        private boolean verifyLogoutTokenClaims(TokenVerificationResult result) {
            JsonObject events = result.localVerificationResult.getJsonObject("events");
            if (events == null || events.getJsonObject("http://schemas.openid.net/event/backchannel-logout") == null) {
                LOG.debug((Object)"Back channel logout token does not have a valid 'events' claim");
                return false;
            }
            if (!result.localVerificationResult.containsKey(this.oidcTenantConfig.logout.backchannel.logoutTokenKey)) {
                LOG.debugf("Back channel logout token does not have %s", (Object)this.oidcTenantConfig.logout.backchannel.logoutTokenKey);
                return false;
            }
            if (result.localVerificationResult.containsKey(Claims.nonce.name())) {
                LOG.debug((Object)"Back channel logout token must not contain 'nonce' claim");
                return false;
            }
            return true;
        }

        private TenantConfigContext getTenantConfigContext(String requestPath) {
            if (this.isMatchingTenant(requestPath, BackChannelLogoutHandler.this.resolver.getTenantConfigBean().getDefaultTenant())) {
                return BackChannelLogoutHandler.this.resolver.getTenantConfigBean().getDefaultTenant();
            }
            for (TenantConfigContext tenant : BackChannelLogoutHandler.this.resolver.getTenantConfigBean().getStaticTenantsConfig().values()) {
                if (!this.isMatchingTenant(requestPath, tenant)) continue;
                return tenant;
            }
            return null;
        }

        private boolean isMatchingTenant(String requestPath, TenantConfigContext tenant) {
            return tenant.oidcConfig().isTenantEnabled() && tenant.oidcConfig().getTenantId().get().equals(this.oidcTenantConfig.getTenantId().get()) && requestPath.equals(BackChannelLogoutHandler.this.getRootPath() + (String)tenant.oidcConfig().logout.backchannel.path.orElse(null));
        }
    }
}

