/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.ClientProxy;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.OidcRedirectFilter;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.Redirect;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import io.quarkus.oidc.runtime.OidcProvider;
import io.quarkus.oidc.runtime.OidcProviderClientImpl;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TenantFeatureFinder;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;

final class TenantConfigContextImpl
implements TenantConfigContext {
    private static final Logger LOG = Logger.getLogger(TenantConfigContextImpl.class);
    private final OidcProvider provider;
    private final OidcTenantConfig oidcConfig;
    private final Map<Redirect.Location, List<OidcRedirectFilter>> redirectFilters;
    private final SecretKey stateSecretKey;
    private final SecretKey tokenEncSecretKey;
    private final SecretKey internalIdTokenGeneratedKey;
    private final boolean ready;

    TenantConfigContextImpl(OidcProvider client, OidcTenantConfig config) {
        this(client, config, true);
    }

    TenantConfigContextImpl(OidcProvider provider, OidcTenantConfig config, boolean ready) {
        this.provider = provider;
        this.oidcConfig = config;
        this.redirectFilters = TenantConfigContextImpl.getRedirectFiltersMap(TenantFeatureFinder.find(config, OidcRedirectFilter.class));
        this.ready = ready;
        boolean isService = OidcUtils.isServiceApp(config);
        this.stateSecretKey = !isService && provider != null && provider.client != null ? TenantConfigContextImpl.createStateSecretKey(config) : null;
        this.tokenEncSecretKey = !isService && provider != null && provider.client != null ? TenantConfigContextImpl.createTokenEncSecretKey(config, provider) : null;
        this.internalIdTokenGeneratedKey = !isService && provider != null && provider.client != null ? TenantConfigContextImpl.generateIdTokenSecretKey(config, provider) : null;
    }

    private static SecretKey createStateSecretKey(OidcTenantConfig config) {
        if (config.authentication().pkceRequired().orElse(false).booleanValue() || config.authentication().nonceRequired()) {
            String stateSecret = null;
            if (config.authentication().pkceSecret().isPresent() && config.authentication().stateSecret().isPresent()) {
                throw new ConfigurationException("Both 'quarkus.oidc.authentication.state-secret' and 'quarkus.oidc.authentication.pkce-secret' are configured");
            }
            if (config.authentication().stateSecret().isPresent()) {
                stateSecret = config.authentication().stateSecret().get();
            } else if (config.authentication().pkceSecret().isPresent()) {
                stateSecret = config.authentication().pkceSecret().get();
            }
            if (stateSecret == null) {
                LOG.debug((Object)"'quarkus.oidc.authentication.state-secret' is not configured");
                String possiblePkceSecret = OidcCommonUtils.getClientOrJwtSecret((OidcClientCommonConfig.Credentials)config.credentials());
                if (possiblePkceSecret != null && possiblePkceSecret.length() < 32) {
                    LOG.debug((Object)"Client secret is less than 32 characters long, the state secret will be generated");
                } else {
                    stateSecret = possiblePkceSecret;
                }
            }
            try {
                if (stateSecret == null) {
                    LOG.debug((Object)"Secret key for encrypting state cookie is missing, auto-generating it");
                    SecretKey key = OidcCommonUtils.generateSecretKey();
                    return key;
                }
                byte[] secretBytes = stateSecret.getBytes(StandardCharsets.UTF_8);
                if (secretBytes.length < 32) {
                    String errorMessage = "Secret key for encrypting state cookie should be at least 32 characters long for the strongest state cookie encryption to be produced. Please update 'quarkus.oidc.authentication.state-secret' or update the configured client secret.";
                    if (secretBytes.length < 16) {
                        throw new ConfigurationException("Secret key for encrypting state cookie is less than 16 characters long");
                    }
                    LOG.debug((Object)errorMessage);
                }
                return new SecretKeySpec(OidcUtils.getSha256Digest(secretBytes), "AES");
            }
            catch (Exception ex) {
                throw new OIDCException(ex);
            }
        }
        return null;
    }

    private static SecretKey createTokenEncSecretKey(OidcTenantConfig config, OidcProvider provider) {
        if (config.tokenStateManager().encryptionRequired()) {
            String encSecret = null;
            if (config.tokenStateManager().encryptionSecret().isPresent()) {
                encSecret = config.tokenStateManager().encryptionSecret().get();
            } else {
                LOG.debug((Object)"'quarkus.oidc.token-state-manager.encryption-secret' is not configured");
                encSecret = OidcCommonUtils.getClientOrJwtSecret((OidcClientCommonConfig.Credentials)config.credentials());
            }
            try {
                if (encSecret != null) {
                    byte[] secretBytes = encSecret.getBytes(StandardCharsets.UTF_8);
                    if (secretBytes.length < 32) {
                        String errorMessage = "Secret key for encrypting tokens in a session cookie should be at least 32 characters long for the strongest cookie encryption to be produced. Please configure 'quarkus.oidc.token-state-manager.encryption-secret' or update the configured client secret. You can disable the session cookie encryption with 'quarkus.oidc.token-state-manager.encryption-required=false' but only if it is considered to be safe in your application's network.";
                        if (secretBytes.length < 16) {
                            LOG.warn((Object)errorMessage);
                        } else {
                            LOG.debug((Object)errorMessage);
                        }
                    }
                    return OidcUtils.createSecretKeyFromDigest(secretBytes);
                }
                if (provider.client.getClientJwtKey() instanceof PrivateKey) {
                    return OidcUtils.createSecretKeyFromDigest(((PrivateKey)provider.client.getClientJwtKey()).getEncoded());
                }
                LOG.warn((Object)"Secret key for encrypting OIDC authorization code flow tokens in a session cookie is not configured, auto-generating it. Note that a new secret will be generated after a restart, thus making it impossible to decrypt the session cookie and requiring a user re-authentication. Use 'quarkus.oidc.token-state-manager.encryption-secret' to configure an encryption secret. Alternatively, disable session cookie encryption with 'quarkus.oidc.token-state-manager.encryption-required=false' but only if it is considered to be safe in your application's network.");
                return OidcCommonUtils.generateSecretKey();
            }
            catch (Exception ex) {
                throw new OIDCException(ex);
            }
        }
        return null;
    }

    private static SecretKey generateIdTokenSecretKey(OidcTenantConfig config, OidcProvider provider) {
        try {
            return config.authentication().idTokenRequired().orElse(true) == false && OidcCommonUtils.getClientOrJwtSecret((OidcClientCommonConfig.Credentials)config.credentials()) == null && provider.client.getClientJwtKey() == null ? OidcCommonUtils.generateSecretKey() : null;
        }
        catch (Exception ex) {
            throw new OIDCException(ex);
        }
    }

    @Override
    public OidcTenantConfig oidcConfig() {
        return this.oidcConfig;
    }

    @Override
    public OidcProvider provider() {
        return this.provider;
    }

    @Override
    public boolean ready() {
        return this.ready;
    }

    @Override
    public OidcTenantConfig getOidcTenantConfig() {
        return this.oidcConfig;
    }

    @Override
    public OidcConfigurationMetadata getOidcMetadata() {
        return this.provider != null ? this.provider.getMetadata() : null;
    }

    @Override
    public OidcProviderClientImpl getOidcProviderClient() {
        return this.provider != null ? this.provider.client : null;
    }

    @Override
    public SecretKey getStateEncryptionKey() {
        return this.stateSecretKey;
    }

    @Override
    public SecretKey getTokenEncSecretKey() {
        return this.tokenEncSecretKey;
    }

    @Override
    public SecretKey getInternalIdTokenSecretKey() {
        return this.internalIdTokenGeneratedKey;
    }

    private static Map<Redirect.Location, List<OidcRedirectFilter>> getRedirectFiltersMap(List<OidcRedirectFilter> filters) {
        HashMap<Redirect.Location, List<OidcRedirectFilter>> map = new HashMap<Redirect.Location, List<OidcRedirectFilter>>();
        for (OidcRedirectFilter filter : filters) {
            Redirect redirect = ((OidcRedirectFilter)ClientProxy.unwrap((Object)filter)).getClass().getAnnotation(Redirect.class);
            if (redirect != null) {
                for (Redirect.Location loc : redirect.value()) {
                    map.computeIfAbsent(loc, k -> new ArrayList()).add(filter);
                }
                continue;
            }
            map.computeIfAbsent(Redirect.Location.ALL, k -> new ArrayList()).add(filter);
        }
        return map;
    }

    @Override
    public List<OidcRedirectFilter> getOidcRedirectFilters(Redirect.Location loc) {
        List<OidcRedirectFilter> typeSpecific = this.redirectFilters.get((Object)loc);
        List<OidcRedirectFilter> all = this.redirectFilters.get((Object)Redirect.Location.ALL);
        if (typeSpecific == null && all == null) {
            return List.of();
        }
        if (typeSpecific != null && all == null) {
            return typeSpecific;
        }
        if (typeSpecific == null && all != null) {
            return all;
        }
        ArrayList<OidcRedirectFilter> combined = new ArrayList<OidcRedirectFilter>(typeSpecific.size() + all.size());
        combined.addAll(typeSpecific);
        combined.addAll(all);
        return combined;
    }
}

