/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TrustStoreUtils;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.Function;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.jboss.logging.Logger;

public class BearerAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    private static final Logger LOG = Logger.getLogger(BearerAuthenticationMechanism.class);

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager, OidcTenantConfig oidcTenantConfig) {
        LOG.debug((Object)"Starting a bearer access token authentication");
        String token = OidcUtils.extractBearerToken(context, oidcTenantConfig);
        if (token != null) {
            try {
                BearerAuthenticationMechanism.setCertificateThumbprint(context, oidcTenantConfig);
                BearerAuthenticationMechanism.setDPopProof(context, oidcTenantConfig);
            }
            catch (AuthenticationFailedException ex) {
                return Uni.createFrom().failure((Throwable)ex);
            }
            return this.authenticate(identityProviderManager, context, new AccessTokenCredential(token));
        }
        LOG.debug((Object)"Bearer access token is not available");
        return Uni.createFrom().nullItem();
    }

    private static void setCertificateThumbprint(RoutingContext context, OidcTenantConfig oidcTenantConfig) {
        if (oidcTenantConfig.token().binding().certificate()) {
            Certificate cert = BearerAuthenticationMechanism.getCertificate(context);
            if (!(cert instanceof X509Certificate)) {
                LOG.warn((Object)"Access token must be bound to X509 client certiifcate");
                throw new AuthenticationFailedException();
            }
            context.put("x5t#S256", (Object)TrustStoreUtils.calculateThumprint((X509Certificate)cert));
        }
    }

    private static void setDPopProof(RoutingContext context, OidcTenantConfig oidcTenantConfig) {
        if ("DPoP".equals(oidcTenantConfig.token().authorizationScheme())) {
            List proofs = context.request().headers().getAll("DPoP");
            if (proofs == null || proofs.isEmpty()) {
                LOG.warn((Object)"DPOP proof header must be present to verify the DPOP access token binding");
                throw new AuthenticationFailedException();
            }
            if (proofs.size() != 1) {
                LOG.warn((Object)"Only a single DPOP proof header is accepted");
                throw new AuthenticationFailedException();
            }
            String proof = (String)proofs.get(0);
            JsonObject proofJwtHeaders = OidcUtils.decodeJwtHeaders(proof);
            JsonObject proofJwtClaims = OidcCommonUtils.decodeJwtContent((String)proof);
            if (!"dpop+jwt".equals(proofJwtHeaders.getString("typ"))) {
                LOG.warn((Object)"Invalid DPOP proof token type ('typ') header");
                throw new AuthenticationFailedException();
            }
            String proofHttpMethod = proofJwtClaims.getString("htm");
            if (proofHttpMethod == null) {
                LOG.warn((Object)"DPOP proof HTTP method claim is missing");
                throw new AuthenticationFailedException();
            }
            String httpMethod = context.request().method().name();
            if (!httpMethod.equals(proofHttpMethod)) {
                LOG.warnf("DPOP proof HTTP method claim %s does not match the request HTTP method %s", (Object)proofHttpMethod, (Object)httpMethod);
                throw new AuthenticationFailedException();
            }
            String proofHttpRequestUri = proofJwtClaims.getString("htu");
            if (proofHttpRequestUri == null) {
                LOG.warn((Object)"DPOP proof HTTP request uri claim is missing");
                throw new AuthenticationFailedException();
            }
            String httpRequestUri = context.request().absoluteURI();
            int queryIndex = httpRequestUri.indexOf("?");
            if (queryIndex > 0) {
                httpRequestUri = httpRequestUri.substring(0, queryIndex);
            }
            if (!httpRequestUri.equals(proofHttpRequestUri)) {
                LOG.warnf("DPOP proof HTTP request uri claim %s does not match the request HTTP uri %s", (Object)proofHttpRequestUri, (Object)httpRequestUri);
                throw new AuthenticationFailedException();
            }
            context.put("dpop_proof", (Object)proof);
            context.put("dpop_proof_jwt_headers", (Object)proofJwtHeaders);
            context.put("dpop_proof_jwt_claims", (Object)proofJwtClaims);
        }
    }

    private static Certificate getCertificate(RoutingContext context) {
        try {
            return context.request().sslSession().getPeerCertificates()[0];
        }
        catch (SSLPeerUnverifiedException e) {
            LOG.warn((Object)"Access token must be certificate bound but no client certificate is available");
            throw new AuthenticationFailedException();
        }
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        Uni<TenantConfigContext> tenantContext = this.resolver.resolveContext(context);
        return tenantContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends ChallengeData>>(){

            @Override
            public Uni<ChallengeData> apply(TenantConfigContext tenantContext) {
                return Uni.createFrom().item((Object)new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), (CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, tenantContext.oidcConfig().token().authorizationScheme()));
            }
        });
    }
}

