/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.vertx.http.runtime.security.ImmutablePathMatcher;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.HashMap;
import org.jboss.logging.Logger;

@Singleton
public class ResourceMetadataHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(ResourceMetadataHandler.class);
    private static final String SLASH = "/";
    private static final String HTTP_SCHEME = "http";
    private static final String RESOURCE_METADATA_AUTHENTICATE_PARAM = "resource_metadata";
    private final DefaultTenantConfigResolver resolver;
    private volatile ImmutablePathMatcher<Handler<RoutingContext>> pathMatcher;

    ResourceMetadataHandler(DefaultTenantConfigResolver resolver) {
        this.resolver = resolver;
        this.pathMatcher = null;
    }

    public void handle(RoutingContext routingContext) {
        Handler routeHandler;
        ImmutablePathMatcher<Handler<RoutingContext>> matcher = this.pathMatcher;
        if (matcher != null && (routeHandler = (Handler)matcher.match(routingContext.normalizedPath()).getValue()) != null) {
            routeHandler.handle((Object)routingContext);
            return;
        }
        routingContext.next();
    }

    void setup(@Observes Router router) {
        this.createOrUpdatePathMatcher();
    }

    synchronized void updatePathMatcher(@Observes NewResourceMetadata ignored) {
        this.createOrUpdatePathMatcher();
    }

    private void createOrUpdatePathMatcher() {
        ImmutablePathMatcher.ImmutablePathMatcherBuilder builder = null;
        HashMap<String, OidcTenantConfig> pathCache = null;
        for (TenantConfigContext configContext : this.resolver.getTenantConfigBean().getAllTenantConfigs()) {
            String currentTenantId;
            String routePath;
            if (!configContext.ready() || !configContext.oidcConfig().tenantEnabled() || !configContext.oidcConfig().resourceMetadata().enabled()) continue;
            if (builder == null) {
                builder = ImmutablePathMatcher.builder();
                pathCache = new HashMap<String, OidcTenantConfig>();
            }
            if ((routePath = ResourceMetadataHandler.getResourceMetadataPath(configContext.oidcConfig(), this.resolver.getRootPath())).contains("*")) {
                throw new IllegalStateException("Resource metadata path cannot contain a wildcard '*' character");
            }
            OidcTenantConfig previousConfig = pathCache.put(routePath, configContext.oidcConfig());
            if (previousConfig == null) {
                RouteHandler routeHandler = new RouteHandler(configContext.oidcConfig(), this.resolver);
                builder.addPath(routePath, (Object)routeHandler);
                continue;
            }
            String previousTenantId = previousConfig.tenantId().get();
            if (previousTenantId.equals(currentTenantId = configContext.oidcConfig().tenantId().get())) continue;
            String errorMessage = "OIDC tenants '%s' and '%s' share the same resource metadata path '%s', which is not supported".formatted(previousTenantId, currentTenantId, routePath);
            LOG.error((Object)errorMessage);
            throw new OIDCException(errorMessage);
        }
        this.pathMatcher = builder != null ? builder.build() : null;
    }

    static String getResourceMetadataPath(OidcTenantConfig oidcConfig, String configuredRootPath) {
        String configuredResource = oidcConfig.resourceMetadata().resource().orElse("");
        String relativePath = null;
        relativePath = configuredResource.startsWith(HTTP_SCHEME) ? URI.create(configuredResource).getRawPath() : configuredResource;
        String protectedResourceMetadataPath = OidcUtils.getRootPath(configuredRootPath) + "/.well-known/oauth-protected-resource";
        if (!relativePath.isEmpty()) {
            if (!SLASH.equals(relativePath)) {
                protectedResourceMetadataPath = protectedResourceMetadataPath + OidcCommonUtils.prependSlash((String)relativePath);
            }
        } else if (!"Default".equals(oidcConfig.tenantId().get())) {
            protectedResourceMetadataPath = protectedResourceMetadataPath + OidcCommonUtils.prependSlash((String)oidcConfig.tenantId().get().toLowerCase());
        }
        return protectedResourceMetadataPath;
    }

    static void fireResourceMetadataChangedEvent(OidcTenantConfig oidcConfig, TenantConfigContext tenant) {
        if (oidcConfig.resourceMetadata().enabled() || tenant.oidcConfig() != null && tenant.oidcConfig().resourceMetadata().enabled()) {
            boolean resourceChanged;
            boolean bl = resourceChanged = tenant.oidcConfig() == null || !oidcConfig.resourceMetadata().resource().orElse("").equals(tenant.oidcConfig().resourceMetadata().resource().orElse("")) || oidcConfig.resourceMetadata().enabled() != tenant.oidcConfig().resourceMetadata().enabled() || oidcConfig.resourceMetadata().forceHttpsScheme() != tenant.oidcConfig().resourceMetadata().forceHttpsScheme();
            if (resourceChanged) {
                ResourceMetadataHandler.fireResourceMetadataEvent();
            }
        }
    }

    static void fireResourceMetadataReadyEvent(OidcTenantConfig oidcConfig) {
        if (oidcConfig.resourceMetadata().enabled()) {
            ResourceMetadataHandler.fireResourceMetadataEvent();
        }
    }

    private static void fireResourceMetadataEvent() {
        Event event = Arc.container().beanManager().getEvent().select(NewResourceMetadata.class, new Annotation[0]);
        event.fire((Object)new NewResourceMetadata());
    }

    static String resourceMetadataAuthenticateParameter(RoutingContext context, DefaultTenantConfigResolver resolver, OidcTenantConfig oidcConfig) {
        return " resource_metadata=\"" + ResourceMetadataHandler.buildAbsoluteResourceIdentifierUrl(context, resolver, oidcConfig) + "\"";
    }

    static String buildResourceIdentifierUrl(RoutingContext context, DefaultTenantConfigResolver resolver, OidcTenantConfig oidcConfig) {
        Object configuredResource = oidcConfig.resourceMetadata().resource().orElse("");
        if (((String)configuredResource).startsWith(HTTP_SCHEME)) {
            return configuredResource;
        }
        if (!((String)configuredResource).isEmpty()) {
            if (!SLASH.equals(configuredResource)) {
                configuredResource = OidcCommonUtils.prependSlash((String)configuredResource);
            }
        } else if (!"Default".equals(oidcConfig.tenantId().get())) {
            configuredResource = (String)configuredResource + OidcCommonUtils.prependSlash((String)oidcConfig.tenantId().get().toLowerCase());
        }
        String authority = URI.create(context.request().absoluteURI()).getAuthority();
        return ResourceMetadataHandler.buildUri(context, resolver.isEnableHttpForwardedPrefix(), oidcConfig.resourceMetadata().forceHttpsScheme(), authority, (String)configuredResource);
    }

    static String buildAbsoluteResourceIdentifierUrl(RoutingContext context, DefaultTenantConfigResolver resolver, OidcTenantConfig oidcConfig) {
        String configuredResource = ResourceMetadataHandler.getResourceMetadataPath(oidcConfig, resolver.getRootPath());
        if (configuredResource.startsWith(HTTP_SCHEME)) {
            return configuredResource;
        }
        String authority = URI.create(context.request().absoluteURI()).getAuthority();
        return ResourceMetadataHandler.buildUri(context, resolver.isEnableHttpForwardedPrefix(), oidcConfig.resourceMetadata().forceHttpsScheme(), authority, configuredResource);
    }

    private static String buildUri(RoutingContext context, boolean enableHttpForwardedPrefix, boolean forceHttps, String authority, String path) {
        String forwardedPrefixHeader;
        String scheme = forceHttps ? "https" : context.request().scheme();
        String forwardedPrefix = "";
        if (enableHttpForwardedPrefix && (forwardedPrefixHeader = context.request().getHeader("X-Forwarded-Prefix")) != null && !forwardedPrefixHeader.equals(SLASH) && !forwardedPrefixHeader.equals("//") && (forwardedPrefix = forwardedPrefixHeader).endsWith(SLASH)) {
            forwardedPrefix = forwardedPrefix.substring(0, forwardedPrefix.length() - 1);
        }
        return scheme + "://" + authority + forwardedPrefix + path;
    }

    private static class RouteHandler
    implements Handler<RoutingContext> {
        private final OidcTenantConfig oidcConfig;
        private final DefaultTenantConfigResolver resolver;

        RouteHandler(OidcTenantConfig oidcTenantConfig, DefaultTenantConfigResolver resolver) {
            this.oidcConfig = oidcTenantConfig;
            this.resolver = resolver;
        }

        public void handle(RoutingContext context) {
            LOG.debugf("Resource metadata request for the tenant %s received", (Object)this.oidcConfig.tenantId().get());
            context.response().setStatusCode(200);
            context.response().end(this.prepareMetadata(context));
        }

        private String prepareMetadata(RoutingContext context) {
            JsonObject metadata = new JsonObject();
            String resourceIdentifier = ResourceMetadataHandler.buildResourceIdentifierUrl(context, this.resolver, this.oidcConfig);
            metadata.put("resource", (Object)resourceIdentifier);
            JsonArray authorizationServers = new JsonArray();
            authorizationServers.add(0, this.oidcConfig.authServerUrl().get());
            metadata.put("authorization_servers", (Object)authorizationServers);
            return metadata.toString();
        }
    }

    record NewResourceMetadata() {
    }
}

