/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TenantFeature;
import io.quarkus.oidc.TokenCustomizer;
import java.lang.annotation.Annotation;

public class TokenCustomizerFinder {
    private TokenCustomizerFinder() {
    }

    public static TokenCustomizer find(OidcTenantConfig oidcConfig) {
        if (oidcConfig == null) {
            return null;
        }
        ArcContainer container = Arc.container();
        if (container != null) {
            String customizerName = oidcConfig.token.customizerName.orElse(null);
            if (customizerName != null && !customizerName.isEmpty()) {
                InstanceHandle tokenCustomizer = container.instance(customizerName);
                if (tokenCustomizer.isAvailable()) {
                    return (TokenCustomizer)tokenCustomizer.get();
                }
                throw new OIDCException("Unable to find TokenCustomizer " + customizerName);
            }
            for (InstanceHandle tokenCustomizer : container.listAll(TokenCustomizer.class, new Annotation[0])) {
                TenantFeature tenantAnn = ((TokenCustomizer)tokenCustomizer.get()).getClass().getAnnotation(TenantFeature.class);
                if (tenantAnn == null || !oidcConfig.tenantId.get().equals(tenantAnn.value())) continue;
                return (TokenCustomizer)tokenCustomizer.get();
            }
        }
        return null;
    }
}

