/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime.devui;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.runtime.devui.OidcDevServicesUtils;
import io.quarkus.oidc.runtime.devui.OidcDevUiRpcSvcPropertiesBean;
import io.quarkus.oidc.runtime.devui.OidcDevUiRuntimePropertiesDTO;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.Config;

public class OidcDevJsonRpcService {
    private final String authorizationUrl;
    private final String tokenUrl;
    private final String logoutUrl;
    private final Duration timeout;
    private final Map<String, String> codeGrantOptions;
    private final Map<String, String> passwordGrantOptions;
    private final Map<String, String> clientCredGrantOptions;
    private final Map<String, String> oidcUserToPassword;
    private final int httpPort;
    private final SmallRyeConfig config;
    private final Vertx vertx;
    private final String oidcProviderName;
    private final String oidcApplicationType;
    private final String oidcGrantType;
    private final boolean introspectionIsAvailable;
    private final String keycloakAdminUrl;
    private final List<String> keycloakRealms;
    private final boolean swaggerIsAvailable;
    private final boolean graphqlIsAvailable;
    private final String swaggerUiPath;
    private final String graphqlUiPath;
    private final boolean alwaysLogoutUserInDevUiOnReload;
    private final String propertiesStateId;

    public OidcDevJsonRpcService(HttpConfiguration httpConfiguration, SmallRyeConfig config, Vertx vertx) {
        OidcDevUiRpcSvcPropertiesBean props = (OidcDevUiRpcSvcPropertiesBean)Arc.container().instance(OidcDevUiRpcSvcPropertiesBean.class, new Annotation[0]).get();
        this.httpPort = httpConfiguration.port;
        this.config = config;
        this.vertx = vertx;
        this.authorizationUrl = props.getAuthorizationUrl();
        this.tokenUrl = props.getTokenUrl();
        this.logoutUrl = props.getLogoutUrl();
        this.timeout = props.getWebClientTimeout();
        this.codeGrantOptions = props.getCodeGrantOptions();
        this.passwordGrantOptions = props.getPasswordGrantOptions();
        this.clientCredGrantOptions = props.getClientCredGrantOptions();
        this.oidcUserToPassword = props.getOidcUsers();
        this.oidcProviderName = props.getOidcProviderName();
        this.oidcApplicationType = props.getOidcApplicationType();
        this.oidcGrantType = props.getOidcGrantType();
        this.introspectionIsAvailable = props.isIntrospectionIsAvailable();
        this.keycloakAdminUrl = props.getKeycloakAdminUrl();
        this.keycloakRealms = props.getKeycloakRealms();
        this.swaggerIsAvailable = props.isSwaggerIsAvailable();
        this.graphqlIsAvailable = props.isGraphqlIsAvailable();
        this.swaggerUiPath = props.getSwaggerUiPath();
        this.graphqlUiPath = props.getGraphqlUiPath();
        this.alwaysLogoutUserInDevUiOnReload = props.isAlwaysLogoutUserInDevUiOnReload();
        this.propertiesStateId = props.getPropertiesStateId();
    }

    @NonBlocking
    public OidcDevUiRuntimePropertiesDTO getProperties() {
        return new OidcDevUiRuntimePropertiesDTO(this.authorizationUrl, this.tokenUrl, this.logoutUrl, (Config)this.config, this.httpPort, this.oidcProviderName, this.oidcApplicationType, this.oidcGrantType, this.introspectionIsAvailable, this.keycloakAdminUrl, this.keycloakRealms, this.swaggerIsAvailable, this.graphqlIsAvailable, this.swaggerUiPath, this.graphqlUiPath, this.alwaysLogoutUserInDevUiOnReload, this.propertiesStateId);
    }

    public Uni<String> exchangeCodeForTokens(String tokenUrl, String clientId, String clientSecret, String authorizationCode, String redirectUri) {
        return OidcDevServicesUtils.getTokens(tokenUrl, clientId, clientSecret, authorizationCode, redirectUri, this.vertx, this.codeGrantOptions).ifNoItem().after(this.timeout).fail();
    }

    public Uni<Integer> testServiceWithToken(String token, String serviceUrl) {
        return OidcDevServicesUtils.testServiceWithToken(serviceUrl, token, this.vertx).ifNoItem().after(this.timeout).fail();
    }

    public Uni<String> testServiceWithPassword(String tokenUrl, String serviceUrl, String clientId, String clientSecret, String username, String password) {
        return OidcDevServicesUtils.testServiceWithPassword(tokenUrl, serviceUrl, clientId, clientSecret, username, password, this.vertx, this.timeout, this.passwordGrantOptions, this.oidcUserToPassword);
    }

    public Uni<String> testServiceWithClientCred(String tokenUrl, String serviceUrl, String clientId, String clientSecret) {
        return OidcDevServicesUtils.testServiceWithClientCred(tokenUrl, serviceUrl, clientId, clientSecret, this.vertx, this.timeout, this.clientCredGrantOptions);
    }
}

