/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.JavaScriptRequestChecker;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.TenantConfigResolver;
import io.quarkus.oidc.TenantResolver;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.runtime.BackChannelLogoutTokenCache;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DefaultTenantConfigResolver {
    private static final Logger LOG = Logger.getLogger(DefaultTenantConfigResolver.class);
    private static final String CURRENT_STATIC_TENANT_ID = "static.tenant.id";
    private static final String CURRENT_STATIC_TENANT_ID_NULL = "static.tenant.id.null";
    private static final String CURRENT_DYNAMIC_TENANT_CONFIG = "dynamic.tenant.config";
    private DefaultStaticTenantResolver defaultStaticTenantResolver = new DefaultStaticTenantResolver();
    @Inject
    Instance<TenantResolver> tenantResolver;
    @Inject
    Instance<TenantConfigResolver> tenantConfigResolver;
    @Inject
    Instance<JavaScriptRequestChecker> javaScriptRequestChecker;
    @Inject
    TenantConfigBean tenantConfigBean;
    @Inject
    Instance<TokenStateManager> tokenStateManager;
    @Inject
    Instance<TokenIntrospectionCache> tokenIntrospectionCache;
    @Inject
    Instance<UserInfoCache> userInfoCache;
    @Inject
    Event<SecurityEvent> securityEvent;
    @Inject
    @ConfigProperty(name="quarkus.http.proxy.enable-forwarded-prefix")
    boolean enableHttpForwardedPrefix;
    private final BlockingTaskRunner<OidcTenantConfig> blockingRequestContext;
    private volatile boolean securityEventObserved;
    private ConcurrentHashMap<String, BackChannelLogoutTokenCache> backChannelLogoutTokens = new ConcurrentHashMap();

    public DefaultTenantConfigResolver(BlockingSecurityExecutor blockingExecutor) {
        this.blockingRequestContext = new BlockingTaskRunner(blockingExecutor);
    }

    @PostConstruct
    public void verifyResolvers() {
        if (this.tenantConfigResolver.isResolvable() && this.tenantConfigResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantConfigResolver.class + " beans registered");
        }
        if (this.tenantResolver.isResolvable() && this.tenantResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantResolver.class + " beans registered");
        }
        if (this.tokenStateManager.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TokenStateManager.class + " beans registered");
        }
        if (this.tokenIntrospectionCache.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TokenIntrospectionCache.class + " beans registered");
        }
        if (this.userInfoCache.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + UserInfo.class + " beans registered");
        }
        if (this.javaScriptRequestChecker.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + JavaScriptRequestChecker.class + " beans registered");
        }
    }

    Uni<OidcTenantConfig> resolveConfig(final RoutingContext context) {
        return this.getDynamicTenantConfig(context).map((Function)new Function<OidcTenantConfig, OidcTenantConfig>(){

            @Override
            public OidcTenantConfig apply(OidcTenantConfig tenantConfig) {
                TenantConfigContext tenant;
                if (tenantConfig == null && (tenant = DefaultTenantConfigResolver.this.getStaticTenantContext(context)) != null) {
                    tenantConfig = tenant.oidcConfig;
                }
                return tenantConfig;
            }
        });
    }

    Uni<TenantConfigContext> resolveContext(String tenantId) {
        return this.initializeTenantIfContextNotReady(this.getStaticTenantContext(tenantId));
    }

    Uni<TenantConfigContext> resolveContext(final RoutingContext context) {
        return this.getDynamicTenantContext(context).onItem().ifNull().switchTo((Supplier)new Supplier<Uni<? extends TenantConfigContext>>(){

            @Override
            public Uni<? extends TenantConfigContext> get() {
                return DefaultTenantConfigResolver.this.initializeTenantIfContextNotReady(DefaultTenantConfigResolver.this.getStaticTenantContext(context));
            }
        });
    }

    private Uni<TenantConfigContext> initializeTenantIfContextNotReady(TenantConfigContext tenantContext) {
        if (tenantContext != null && !tenantContext.ready) {
            TenantConfigContext readyTenantContext = this.tenantConfigBean.getDynamicTenantsConfig().get(tenantContext.oidcConfig.tenantId.get());
            if (readyTenantContext == null) {
                LOG.debugf("Tenant '%s' is not initialized yet, trying to create OIDC connection now", (Object)tenantContext.oidcConfig.tenantId.get());
                return this.tenantConfigBean.getTenantConfigContextFactory().apply(tenantContext.oidcConfig);
            }
            tenantContext = readyTenantContext;
        }
        return Uni.createFrom().item((Object)tenantContext);
    }

    private TenantConfigContext getStaticTenantContext(RoutingContext context) {
        String tenantId = (String)context.get(CURRENT_STATIC_TENANT_ID);
        if (tenantId == null && context.get(CURRENT_STATIC_TENANT_ID_NULL) == null) {
            if (this.tenantResolver.isResolvable()) {
                tenantId = ((TenantResolver)this.tenantResolver.get()).resolve(context);
            }
            if (tenantId == null && this.tenantConfigBean.getStaticTenantsConfig().size() > 0) {
                tenantId = this.defaultStaticTenantResolver.resolve(context);
            }
            if (tenantId == null) {
                tenantId = (String)context.get("tenant-id");
            }
        }
        if (tenantId != null) {
            context.put(CURRENT_STATIC_TENANT_ID, (Object)tenantId);
        } else {
            context.put(CURRENT_STATIC_TENANT_ID_NULL, (Object)true);
        }
        return this.getStaticTenantContext(tenantId);
    }

    private TenantConfigContext getStaticTenantContext(String tenantId) {
        TenantConfigContext configContext;
        TenantConfigContext tenantConfigContext = configContext = tenantId != null ? this.tenantConfigBean.getStaticTenantsConfig().get(tenantId) : null;
        if (configContext == null) {
            if (tenantId != null && !tenantId.isEmpty()) {
                LOG.debugf("Registered TenantResolver has not provided the configuration for tenant '%s', using the default tenant", (Object)tenantId);
            }
            configContext = this.tenantConfigBean.getDefaultTenant();
        }
        return configContext;
    }

    boolean isSecurityEventObserved() {
        return this.securityEventObserved;
    }

    void setSecurityEventObserved(boolean securityEventObserved) {
        this.securityEventObserved = securityEventObserved;
    }

    Event<SecurityEvent> getSecurityEvent() {
        return this.securityEvent;
    }

    TokenStateManager getTokenStateManager() {
        return (TokenStateManager)this.tokenStateManager.get();
    }

    TokenIntrospectionCache getTokenIntrospectionCache() {
        return this.tokenIntrospectionCache.isResolvable() ? (TokenIntrospectionCache)this.tokenIntrospectionCache.get() : null;
    }

    UserInfoCache getUserInfoCache() {
        return this.userInfoCache.isResolvable() ? (UserInfoCache)this.userInfoCache.get() : null;
    }

    private Uni<OidcTenantConfig> getDynamicTenantConfig(RoutingContext context) {
        if (this.tenantConfigResolver.isResolvable()) {
            Uni oidcConfig = (Uni)context.get(CURRENT_DYNAMIC_TENANT_CONFIG);
            if (oidcConfig == null) {
                oidcConfig = ((TenantConfigResolver)this.tenantConfigResolver.get()).resolve(context, this.blockingRequestContext);
                if (oidcConfig == null) {
                    oidcConfig = Uni.createFrom().nullItem();
                }
                oidcConfig = (oidcConfig = oidcConfig.memoize().indefinitely()) == null ? Uni.createFrom().nullItem() : oidcConfig.onItem().transform(cfg -> OidcUtils.resolveProviderConfig(cfg));
                context.put(CURRENT_DYNAMIC_TENANT_CONFIG, (Object)oidcConfig);
            }
            return oidcConfig;
        }
        return Uni.createFrom().nullItem();
    }

    private Uni<TenantConfigContext> getDynamicTenantContext(RoutingContext context) {
        return this.getDynamicTenantConfig(context).chain((Function)new Function<OidcTenantConfig, Uni<? extends TenantConfigContext>>(){

            @Override
            public Uni<? extends TenantConfigContext> apply(OidcTenantConfig tenantConfig) {
                if (tenantConfig != null) {
                    String tenantId = tenantConfig.getTenantId().orElseThrow(() -> new OIDCException("Tenant configuration must have tenant id"));
                    TenantConfigContext tenantContext = DefaultTenantConfigResolver.this.tenantConfigBean.getDynamicTenantsConfig().get(tenantId);
                    if (tenantContext == null) {
                        return DefaultTenantConfigResolver.this.tenantConfigBean.getTenantConfigContextFactory().apply(tenantConfig);
                    }
                    return Uni.createFrom().item((Object)tenantContext);
                }
                return Uni.createFrom().nullItem();
            }
        });
    }

    boolean isEnableHttpForwardedPrefix() {
        return this.enableHttpForwardedPrefix;
    }

    public Map<String, BackChannelLogoutTokenCache> getBackChannelLogoutTokens() {
        return this.backChannelLogoutTokens;
    }

    public TenantConfigBean getTenantConfigBean() {
        return this.tenantConfigBean;
    }

    public JavaScriptRequestChecker getJavaScriptRequestChecker() {
        return this.javaScriptRequestChecker.isResolvable() ? (JavaScriptRequestChecker)this.javaScriptRequestChecker.get() : null;
    }

    private class DefaultStaticTenantResolver
    implements TenantResolver {
        private DefaultStaticTenantResolver() {
        }

        @Override
        public String resolve(RoutingContext context) {
            String tenantId = (String)context.get("tenant-id");
            if (tenantId != null) {
                return tenantId;
            }
            String[] pathSegments = context.request().path().split("/");
            if (pathSegments.length > 0) {
                String lastPathSegment = pathSegments[pathSegments.length - 1];
                if (DefaultTenantConfigResolver.this.tenantConfigBean.getStaticTenantsConfig().containsKey(lastPathSegment)) {
                    return lastPathSegment;
                }
            }
            return null;
        }
    }
}

