/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.OidcProvider;
import io.quarkus.oidc.runtime.RefreshableVerificationKeyResolver;
import io.quarkus.oidc.runtime.TrustStoreUtils;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.vertx.ext.auth.impl.CertificateHelper;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.UnresolvableKeyException;

public class CertChainPublicKeyResolver
implements RefreshableVerificationKeyResolver {
    private static final Logger LOG = Logger.getLogger(OidcProvider.class);
    final Set<String> thumbprints;

    public CertChainPublicKeyResolver(OidcTenantConfig.CertificateChain chain) {
        if (chain.trustStorePassword.isEmpty()) {
            throw new ConfigurationException("Truststore with configured password which keeps thumbprints of the trusted certificates must be present");
        }
        this.thumbprints = TrustStoreUtils.getTrustedCertificateThumbprints(chain.trustStoreFile.get(), chain.trustStorePassword.get(), chain.trustStoreCertAlias, chain.getTrustStoreFileType());
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        try {
            List chain = jws.getCertificateChainHeaderValue();
            if (chain == null) {
                LOG.debug((Object)"Token does not have an 'x5c' certificate chain header");
                return null;
            }
            String thumbprint = TrustStoreUtils.calculateThumprint((X509Certificate)chain.get(0));
            if (!this.thumbprints.contains(thumbprint)) {
                throw new UnresolvableKeyException("Certificate chain thumprint is invalid");
            }
            CertificateHelper.checkValidity((List)chain, null);
            if (chain.size() == 1) {
                X509Certificate root = (X509Certificate)chain.get(0);
                root.verify(root.getPublicKey());
            }
            return ((X509Certificate)chain.get(0)).getPublicKey();
        }
        catch (Exception ex) {
            throw new UnresolvableKeyException("Invalid certificate chain", (Throwable)ex);
        }
    }
}

