/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.TenantConfigResolver;
import io.quarkus.oidc.TenantIdentityProvider;
import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.DefaultTokenIntrospectionUserInfoCache;
import io.quarkus.oidc.runtime.JsonWebKeySet;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcIdentityProvider;
import io.quarkus.oidc.runtime.OidcProvider;
import io.quarkus.oidc.runtime.OidcProviderClient;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.ext.web.client.WebClient;
import jakarta.enterprise.event.Event;
import java.lang.annotation.Annotation;
import java.security.Key;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;

@Recorder
public class OidcRecorder {
    private static final Logger LOG = Logger.getLogger(OidcRecorder.class);
    private static final String SECURITY_EVENTS_ENABLED_CONFIG_KEY = "quarkus.security.events.enabled";
    private static final Map<String, TenantConfigContext> dynamicTenantsConfig = new ConcurrentHashMap<String, TenantConfigContext>();
    private static final Set<String> tenantsExpectingServerAvailableEvents = ConcurrentHashMap.newKeySet();

    public Supplier<DefaultTokenIntrospectionUserInfoCache> setupTokenCache(final OidcConfig config, final Supplier<Vertx> vertx) {
        return new Supplier<DefaultTokenIntrospectionUserInfoCache>(){

            @Override
            public DefaultTokenIntrospectionUserInfoCache get() {
                return new DefaultTokenIntrospectionUserInfoCache(config, (Vertx)vertx.get());
            }
        };
    }

    public Supplier<TenantConfigBean> setup(OidcConfig config, Supplier<Vertx> vertx, final TlsConfig tlsConfig) {
        final Vertx vertxValue = vertx.get();
        String defaultTenantId = config.defaultTenant.getTenantId().orElse("Default");
        final TenantConfigContext defaultTenantContext = this.createStaticTenantContext(vertxValue, config.defaultTenant, !config.namedTenants.isEmpty(), tlsConfig, defaultTenantId);
        final HashMap<String, TenantConfigContext> staticTenantsConfig = new HashMap<String, TenantConfigContext>();
        for (Map.Entry<String, OidcTenantConfig> tenant : config.namedTenants.entrySet()) {
            OidcCommonUtils.verifyConfigurationId((String)defaultTenantId, (String)tenant.getKey(), tenant.getValue().getTenantId());
            staticTenantsConfig.put(tenant.getKey(), this.createStaticTenantContext(vertxValue, tenant.getValue(), false, tlsConfig, tenant.getKey()));
        }
        return new Supplier<TenantConfigBean>(){

            @Override
            public TenantConfigBean get() {
                return new TenantConfigBean(staticTenantsConfig, dynamicTenantsConfig, defaultTenantContext, new Function<OidcTenantConfig, Uni<TenantConfigContext>>(){

                    @Override
                    public Uni<TenantConfigContext> apply(OidcTenantConfig config) {
                        return OidcRecorder.this.createDynamicTenantContext(vertxValue, config, tlsConfig, config.getTenantId().get());
                    }
                });
            }
        };
    }

    public RuntimeValue<MethodDescription> methodInfoToDescription(String className, String methodName, String[] paramTypes) {
        return new RuntimeValue((Object)new MethodDescription(className, methodName, paramTypes));
    }

    private Uni<TenantConfigContext> createDynamicTenantContext(Vertx vertx, OidcTenantConfig oidcConfig, TlsConfig tlsConfig, final String tenantId) {
        if (oidcConfig.logout.backchannel.path.isPresent()) {
            throw new ConfigurationException("BackChannel Logout is currently not supported for dynamic tenants");
        }
        if (!dynamicTenantsConfig.containsKey(tenantId)) {
            Uni<TenantConfigContext> uniContext = this.createTenantContext(vertx, oidcConfig, false, tlsConfig, tenantId);
            uniContext.onFailure().transform((Function)new Function<Throwable, Throwable>(){

                @Override
                public Throwable apply(Throwable t) {
                    return OidcRecorder.logTenantConfigContextFailure(t, tenantId);
                }
            });
            return uniContext.onItem().transform((Function)new Function<TenantConfigContext, TenantConfigContext>(){

                @Override
                public TenantConfigContext apply(TenantConfigContext t) {
                    dynamicTenantsConfig.putIfAbsent(tenantId, t);
                    return t;
                }
            });
        }
        return Uni.createFrom().item((Object)dynamicTenantsConfig.get(tenantId));
    }

    private TenantConfigContext createStaticTenantContext(Vertx vertx, final OidcTenantConfig oidcConfig, boolean checkNamedTenants, TlsConfig tlsConfig, final String tenantId) {
        Uni<TenantConfigContext> uniContext = this.createTenantContext(vertx, oidcConfig, checkNamedTenants, tlsConfig, tenantId);
        return (TenantConfigContext)uniContext.onFailure().recoverWithItem((Function)new Function<Throwable, TenantConfigContext>(){

            @Override
            public TenantConfigContext apply(Throwable t) {
                if (t instanceof OIDCException) {
                    LOG.warnf("Tenant '%s': '%s'. OIDC server is not available yet, an attempt to connect will be made during the first request. Access to resources protected by this tenant may fail if OIDC server will not become available", (Object)tenantId, (Object)t.getMessage());
                    return new TenantConfigContext(null, oidcConfig, false);
                }
                OidcRecorder.logTenantConfigContextFailure(t, tenantId);
                if (t instanceof ConfigurationException && !oidcConfig.authServerUrl.isPresent() && LaunchMode.DEVELOPMENT == LaunchMode.current()) {
                    return new TenantConfigContext(null, oidcConfig, false);
                }
                throw new OIDCException(t);
            }
        }).await().atMost(oidcConfig.getConnectionTimeout());
    }

    private static Throwable logTenantConfigContextFailure(Throwable t, String tenantId) {
        LOG.debugf("'%s' tenant is not initialized: '%s'. Access to resources protected by this tenant will fail.", (Object)tenantId, (Object)t.getMessage());
        return t;
    }

    private Uni<TenantConfigContext> createTenantContext(Vertx vertx, OidcTenantConfig oidcTenantConfig, boolean checkNamedTenants, TlsConfig tlsConfig, String tenantId) {
        if (!oidcTenantConfig.tenantId.isPresent()) {
            oidcTenantConfig.tenantId = Optional.of(tenantId);
        }
        final OidcTenantConfig oidcConfig = OidcUtils.resolveProviderConfig(oidcTenantConfig);
        if (!oidcConfig.tenantEnabled) {
            LOG.debugf("'%s' tenant configuration is disabled", (Object)tenantId);
            return Uni.createFrom().item((Object)new TenantConfigContext(new OidcProvider(null, null, null, null), oidcConfig));
        }
        if (!oidcConfig.getAuthServerUrl().isPresent()) {
            if (oidcConfig.getPublicKey().isPresent() && oidcConfig.certificateChain.trustStoreFile.isPresent()) {
                throw new ConfigurationException("Both public key and certificate chain verification modes are enabled");
            }
            if (oidcConfig.getPublicKey().isPresent()) {
                return Uni.createFrom().item((Object)OidcRecorder.createTenantContextFromPublicKey(oidcConfig));
            }
            if (oidcConfig.certificateChain.trustStoreFile.isPresent()) {
                return Uni.createFrom().item((Object)OidcRecorder.createTenantContextToVerifyCertChain(oidcConfig));
            }
        }
        try {
            if (!oidcConfig.getAuthServerUrl().isPresent()) {
                ArcContainer container;
                if ("Default".equals(oidcConfig.tenantId.get()) && (container = Arc.container()) != null && (container.instance(TenantConfigResolver.class, new Annotation[0]).isAvailable() || checkNamedTenants)) {
                    LOG.debugf("Default tenant is not configured and will be disabled because either 'TenantConfigResolver' which will resolve tenant configurations is registered or named tenants are configured.", new Object[0]);
                    oidcConfig.setTenantEnabled(false);
                    return Uni.createFrom().item((Object)new TenantConfigContext(new OidcProvider(null, null, null, null), oidcConfig));
                }
                throw new ConfigurationException("'quarkus.oidc.auth-server-url' property must be configured");
            }
            OidcCommonUtils.verifyEndpointUrl((String)((String)oidcConfig.getAuthServerUrl().get()));
            OidcCommonUtils.verifyCommonConfiguration((OidcCommonConfig)oidcConfig, (boolean)OidcUtils.isServiceApp(oidcConfig), (boolean)true);
        }
        catch (ConfigurationException t) {
            return Uni.createFrom().failure((Throwable)t);
        }
        if (oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.userinfo && !OidcRecorder.enableUserInfo(oidcConfig)) {
            throw new ConfigurationException("UserInfo is not required but UserInfo is expected to be the source of authorization roles");
        }
        if (oidcConfig.token.verifyAccessTokenWithUserInfo.orElse(false).booleanValue() && !OidcUtils.isWebApp(oidcConfig) && !OidcRecorder.enableUserInfo(oidcConfig)) {
            throw new ConfigurationException("UserInfo is not required but 'verifyAccessTokenWithUserInfo' is enabled");
        }
        if (!oidcConfig.authentication.isIdTokenRequired().orElse(true).booleanValue() && !OidcRecorder.enableUserInfo(oidcConfig)) {
            throw new ConfigurationException("UserInfo is not required but it will be needed to verify a code flow access token");
        }
        if (!oidcConfig.discoveryEnabled.orElse(true).booleanValue()) {
            if (!(OidcUtils.isServiceApp(oidcConfig) || oidcConfig.authorizationPath.isPresent() && oidcConfig.tokenPath.isPresent())) {
                throw new ConfigurationException("'web-app' applications must have 'authorization-path' and 'token-path' properties set when the discovery is disabled.", Set.of("quarkus.oidc.authorization-path", "quarkus.oidc.token-path"));
            }
            if (!oidcConfig.jwksPath.isPresent() && !oidcConfig.introspectionPath.isPresent()) {
                if (!oidcConfig.authentication.isIdTokenRequired().orElse(true).booleanValue() && oidcConfig.authentication.isUserInfoRequired().orElse(false).booleanValue()) {
                    LOG.debugf("tenant %s supports only UserInfo", (Object)oidcConfig.tenantId.get());
                } else {
                    throw new ConfigurationException("Either 'jwks-path' or 'introspection-path' properties must be set when the discovery is disabled.", Set.of("quarkus.oidc.jwks-path", "quarkus.oidc.introspection-path"));
                }
            }
            if (oidcConfig.authentication.userInfoRequired.orElse(false).booleanValue() && !oidcConfig.userInfoPath.isPresent()) {
                throw new ConfigurationException("UserInfo is required but 'quarkus.oidc.user-info-path' is not configured.", Set.of("quarkus.oidc.user-info-path"));
            }
        }
        if (OidcUtils.isServiceApp(oidcConfig)) {
            if (oidcConfig.token.refreshExpired) {
                throw new ConfigurationException("The 'token.refresh-expired' property can only be enabled for " + String.valueOf((Object)OidcTenantConfig.ApplicationType.WEB_APP) + " application types");
            }
            if (!oidcConfig.token.refreshTokenTimeSkew.isEmpty()) {
                throw new ConfigurationException("The 'token.refresh-token-time-skew' property can only be enabled for " + String.valueOf((Object)OidcTenantConfig.ApplicationType.WEB_APP) + " application types");
            }
            if (oidcConfig.logout.path.isPresent()) {
                throw new ConfigurationException("The 'logout.path' property can only be enabled for " + String.valueOf((Object)OidcTenantConfig.ApplicationType.WEB_APP) + " application types");
            }
            if (oidcConfig.roles.source.isPresent() && oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.idtoken) {
                throw new ConfigurationException("The 'roles.source' property can only be set to 'idtoken' for " + String.valueOf((Object)OidcTenantConfig.ApplicationType.WEB_APP) + " application types");
            }
        } else if (!oidcConfig.token.refreshTokenTimeSkew.isEmpty()) {
            oidcConfig.token.setRefreshExpired(true);
        }
        if (oidcConfig.tokenStateManager.strategy != OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
            if (oidcConfig.authentication.isUserInfoRequired().orElse(false).booleanValue() || oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.userinfo) {
                throw new ConfigurationException("UserInfo is required but DefaultTokenStateManager is configured to not keep the access token");
            }
            if (oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.accesstoken) {
                throw new ConfigurationException("Access token is required to check the roles but DefaultTokenStateManager is configured to not keep the access token");
            }
        }
        if (oidcConfig.token.verifyAccessTokenWithUserInfo.orElse(false).booleanValue() && !oidcConfig.isDiscoveryEnabled().orElse(true).booleanValue()) {
            if (oidcConfig.userInfoPath.isEmpty()) {
                throw new ConfigurationException("UserInfo path is missing but 'verifyAccessTokenWithUserInfo' is enabled");
            }
            if (oidcConfig.introspectionPath.isPresent()) {
                throw new ConfigurationException("Introspection path is configured and 'verifyAccessTokenWithUserInfo' is enabled, these options are mutually exclusive");
            }
        }
        return OidcRecorder.createOidcProvider(oidcConfig, tlsConfig, vertx).onItem().transform((Function)new Function<OidcProvider, TenantConfigContext>(){

            @Override
            public TenantConfigContext apply(OidcProvider p) {
                return new TenantConfigContext(p, oidcConfig);
            }
        });
    }

    private static boolean enableUserInfo(OidcTenantConfig oidcConfig) {
        Optional<Boolean> userInfoRequired = oidcConfig.authentication.isUserInfoRequired();
        if (userInfoRequired.isPresent()) {
            if (!userInfoRequired.get().booleanValue()) {
                return false;
            }
        } else {
            oidcConfig.authentication.setUserInfoRequired(true);
        }
        return true;
    }

    private static TenantConfigContext createTenantContextFromPublicKey(OidcTenantConfig oidcConfig) {
        if (!OidcUtils.isServiceApp(oidcConfig)) {
            throw new ConfigurationException("'public-key' property can only be used with the 'service' applications");
        }
        LOG.debug((Object)"'public-key' property for the local token verification is set, no connection to the OIDC server will be created");
        return new TenantConfigContext(new OidcProvider(oidcConfig.publicKey.get(), oidcConfig, OidcRecorder.readTokenDecryptionKey(oidcConfig)), oidcConfig);
    }

    private static TenantConfigContext createTenantContextToVerifyCertChain(OidcTenantConfig oidcConfig) {
        if (!OidcUtils.isServiceApp(oidcConfig)) {
            throw new ConfigurationException("Currently only 'service' applications can be used to verify tokens with inlined certificate chains");
        }
        return new TenantConfigContext(new OidcProvider(null, oidcConfig, OidcRecorder.readTokenDecryptionKey(oidcConfig)), oidcConfig);
    }

    public static Optional<ProxyOptions> toProxyOptions(OidcCommonConfig.Proxy proxyConfig) {
        return OidcCommonUtils.toProxyOptions((OidcCommonConfig.Proxy)proxyConfig);
    }

    protected static OIDCException toOidcException(Throwable cause, String authServerUrl, String tenantId) {
        String message = OidcCommonUtils.formatConnectionErrorMessage((String)authServerUrl);
        LOG.warn((Object)message);
        OidcRecorder.fireOidcServerNotAvailableEvent(authServerUrl, tenantId);
        return new OIDCException("OIDC Server is not available", cause);
    }

    protected static Uni<OidcProvider> createOidcProvider(final OidcTenantConfig oidcConfig, TlsConfig tlsConfig, Vertx vertx) {
        return OidcRecorder.createOidcClientUni(oidcConfig, tlsConfig, vertx).onItem().transformToUni((Function)new Function<OidcProviderClient, Uni<? extends OidcProvider>>(){

            @Override
            public Uni<OidcProvider> apply(final OidcProviderClient client) {
                if (oidcConfig.jwks.resolveEarly && client.getMetadata().getJsonWebKeySetUri() != null && !oidcConfig.token.requireJwtIntrospectionOnly) {
                    return OidcRecorder.getJsonWebSetUni(client, oidcConfig).onItem().transform((Function)new Function<JsonWebKeySet, OidcProvider>(){

                        @Override
                        public OidcProvider apply(JsonWebKeySet jwks) {
                            return new OidcProvider(client, oidcConfig, jwks, OidcRecorder.readTokenDecryptionKey(oidcConfig));
                        }
                    });
                }
                return Uni.createFrom().item((Object)new OidcProvider(client, oidcConfig, null, OidcRecorder.readTokenDecryptionKey(oidcConfig)));
            }
        });
    }

    private static Key readTokenDecryptionKey(OidcTenantConfig oidcConfig) {
        if (oidcConfig.token.decryptionKeyLocation.isPresent()) {
            try {
                List keys;
                PrivateKey key = null;
                String keyContent = KeyUtils.readKeyContent((String)oidcConfig.token.decryptionKeyLocation.get());
                if (keyContent != null && (keys = KeyUtils.loadJsonWebKeys((String)keyContent)) != null && keys.size() == 1 && (((JsonWebKey)keys.get(0)).getAlgorithm() == null || ((JsonWebKey)keys.get(0)).getAlgorithm().equals(KeyEncryptionAlgorithm.RSA_OAEP.getAlgorithm())) && ("enc".equals(((JsonWebKey)keys.get(0)).getUse()) || ((JsonWebKey)keys.get(0)).getUse() == null)) {
                    key = ((PublicJsonWebKey)PublicJsonWebKey.class.cast(keys.get(0))).getPrivateKey();
                }
                if (key == null) {
                    key = KeyUtils.decodeDecryptionPrivateKey((String)keyContent);
                }
                return key;
            }
            catch (Exception ex) {
                throw new ConfigurationException(String.format("Token decryption key for tenant %s can not be read from %s", oidcConfig.tenantId.get(), oidcConfig.token.decryptionKeyLocation.get()), (Throwable)ex);
            }
        }
        return null;
    }

    protected static Uni<JsonWebKeySet> getJsonWebSetUni(OidcProviderClient client, final OidcTenantConfig oidcConfig) {
        if (!oidcConfig.isDiscoveryEnabled().orElse(true).booleanValue()) {
            final String tenantId = oidcConfig.tenantId.orElse("Default");
            if (OidcRecorder.shouldFireOidcServerAvailableEvent(tenantId)) {
                return OidcRecorder.getJsonWebSetUniWhenDiscoveryDisabled(client, oidcConfig).invoke(new Runnable(){

                    @Override
                    public void run() {
                        OidcRecorder.fireOidcServerAvailableEvent((String)oidcConfig.authServerUrl.get(), tenantId);
                    }
                });
            }
            return OidcRecorder.getJsonWebSetUniWhenDiscoveryDisabled(client, oidcConfig);
        }
        return client.getJsonWebKeySet((OidcRequestContextProperties)null);
    }

    private static Uni<JsonWebKeySet> getJsonWebSetUniWhenDiscoveryDisabled(OidcProviderClient client, final OidcTenantConfig oidcConfig) {
        long connectionDelayInMillisecs = OidcCommonUtils.getConnectionDelayInMillis((OidcCommonConfig)oidcConfig);
        return client.getJsonWebKeySet((OidcRequestContextProperties)null).onFailure(OidcCommonUtils.oidcEndpointNotAvailable()).retry().withBackOff(OidcCommonUtils.CONNECTION_BACKOFF_DURATION, OidcCommonUtils.CONNECTION_BACKOFF_DURATION).expireIn(connectionDelayInMillisecs).onFailure().transform((Function)new Function<Throwable, Throwable>(){

            @Override
            public Throwable apply(Throwable t) {
                return OidcRecorder.toOidcException(t, (String)oidcConfig.authServerUrl.get(), oidcConfig.tenantId.orElse("Default"));
            }
        }).onFailure().invoke(client::close);
    }

    protected static Uni<OidcProviderClient> createOidcClientUni(final OidcTenantConfig oidcConfig, TlsConfig tlsConfig, final Vertx vertx) {
        final String authServerUriString = OidcCommonUtils.getAuthServerUrl((OidcCommonConfig)oidcConfig);
        WebClientOptions options = new WebClientOptions();
        OidcCommonUtils.setHttpClientOptions((OidcCommonConfig)oidcConfig, (TlsConfig)tlsConfig, (HttpClientOptions)options);
        io.vertx.mutiny.core.Vertx mutinyVertx = new io.vertx.mutiny.core.Vertx(vertx);
        final WebClient client = WebClient.create((io.vertx.mutiny.core.Vertx)mutinyVertx, (WebClientOptions)options);
        final Map oidcRequestFilters = OidcCommonUtils.getOidcRequestFilters();
        Uni metadataUni = null;
        if (!oidcConfig.discoveryEnabled.orElse(true).booleanValue()) {
            metadataUni = Uni.createFrom().item((Object)OidcRecorder.createLocalMetadata(oidcConfig, authServerUriString));
        } else {
            long connectionDelayInMillisecs = OidcCommonUtils.getConnectionDelayInMillis((OidcCommonConfig)oidcConfig);
            metadataUni = OidcCommonUtils.discoverMetadata((WebClient)client, (Map)oidcRequestFilters, (String)authServerUriString, (long)connectionDelayInMillisecs, (io.vertx.mutiny.core.Vertx)mutinyVertx, (boolean)oidcConfig.useBlockingDnsLookup).onItem().transform((Function)new Function<JsonObject, OidcConfigurationMetadata>(){

                @Override
                public OidcConfigurationMetadata apply(JsonObject json) {
                    return new OidcConfigurationMetadata(json, OidcRecorder.createLocalMetadata(oidcConfig, authServerUriString), OidcCommonUtils.getDiscoveryUri((String)authServerUriString));
                }
            });
        }
        return metadataUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<OidcConfigurationMetadata, Throwable, Uni<? extends OidcProviderClient>>(){

            @Override
            public Uni<OidcProviderClient> apply(OidcConfigurationMetadata metadata, Throwable t) {
                String tenantId = oidcConfig.tenantId.orElse("Default");
                if (t != null) {
                    client.close();
                    return Uni.createFrom().failure((Throwable)OidcRecorder.toOidcException(t, authServerUriString, tenantId));
                }
                if (OidcRecorder.shouldFireOidcServerAvailableEvent(tenantId)) {
                    OidcRecorder.fireOidcServerAvailableEvent(authServerUriString, tenantId);
                }
                if (metadata == null) {
                    client.close();
                    return Uni.createFrom().failure((Throwable)new ConfigurationException("OpenId Connect Provider configuration metadata is not configured and can not be discovered"));
                }
                if (oidcConfig.logout.path.isPresent() && !oidcConfig.endSessionPath.isPresent() && metadata.getEndSessionUri() == null) {
                    client.close();
                    return Uni.createFrom().failure((Throwable)new ConfigurationException("The application supports RP-Initiated Logout but the OpenID Provider does not advertise the end_session_endpoint"));
                }
                if (oidcConfig.authentication.userInfoRequired.orElse(false).booleanValue() && metadata.getUserInfoUri() == null) {
                    client.close();
                    return Uni.createFrom().failure((Throwable)new ConfigurationException("UserInfo is required but the OpenID Provider UserInfo endpoint is not configured. Use 'quarkus.oidc.user-info-path' if the discovery is disabled."));
                }
                return Uni.createFrom().item((Object)new OidcProviderClient(client, vertx, metadata, oidcConfig, oidcRequestFilters));
            }
        });
    }

    private static OidcConfigurationMetadata createLocalMetadata(OidcTenantConfig oidcConfig, String authServerUriString) {
        String tokenUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, (Optional)oidcConfig.tokenPath);
        String introspectionUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.introspectionPath);
        String authorizationUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.authorizationPath);
        String jwksUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.jwksPath);
        String userInfoUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.userInfoPath);
        String endSessionUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.endSessionPath);
        return new OidcConfigurationMetadata(tokenUri, introspectionUri, authorizationUri, jwksUri, userInfoUri, endSessionUri, oidcConfig.token.issuer.orElse(null));
    }

    private static void fireOidcServerNotAvailableEvent(String authServerUrl, String tenantId) {
        if (OidcRecorder.fireOidcServerEvent(authServerUrl, SecurityEvent.Type.OIDC_SERVER_NOT_AVAILABLE)) {
            tenantsExpectingServerAvailableEvents.add(tenantId);
        }
    }

    private static void fireOidcServerAvailableEvent(String authServerUrl, String tenantId) {
        if (OidcRecorder.fireOidcServerEvent(authServerUrl, SecurityEvent.Type.OIDC_SERVER_AVAILABLE)) {
            tenantsExpectingServerAvailableEvents.remove(tenantId);
        }
    }

    private static boolean shouldFireOidcServerAvailableEvent(String tenantId) {
        return tenantsExpectingServerAvailableEvents.contains(tenantId);
    }

    private static boolean fireOidcServerEvent(String authServerUrl, SecurityEvent.Type eventType) {
        if (ConfigProvider.getConfig().getOptionalValue(SECURITY_EVENTS_ENABLED_CONFIG_KEY, Boolean.TYPE).orElse(true).booleanValue()) {
            SecurityEventHelper.fire((Event)Arc.container().beanManager().getEvent().select(SecurityEvent.class, new Annotation[0]), (io.quarkus.security.spi.runtime.SecurityEvent)new SecurityEvent(eventType, Map.of("auth-server-url", authServerUrl)));
            return true;
        }
        return false;
    }

    public Consumer<RoutingContext> createTenantResolverInterceptor(final String tenantId) {
        return new Consumer<RoutingContext>(){

            @Override
            public void accept(RoutingContext routingContext) {
                routingContext.put("tenant-id", (Object)tenantId);
            }
        };
    }

    public Supplier<TenantIdentityProvider> createTenantIdentityProvider(final String tenantName) {
        return new Supplier<TenantIdentityProvider>(){

            @Override
            public TenantIdentityProvider get() {
                return new TenantSpecificOidcIdentityProvider(tenantName);
            }
        };
    }

    private static final class TenantSpecificOidcIdentityProvider
    extends OidcIdentityProvider
    implements TenantIdentityProvider {
        private final String tenantId;
        private final BlockingSecurityExecutor blockingExecutor = (BlockingSecurityExecutor)Arc.container().instance(BlockingSecurityExecutor.class, new Annotation[0]).get();

        private TenantSpecificOidcIdentityProvider(String tenantId) {
            super((DefaultTenantConfigResolver)Arc.container().instance(DefaultTenantConfigResolver.class, new Annotation[0]).get(), (BlockingSecurityExecutor)Arc.container().instance(BlockingSecurityExecutor.class, new Annotation[0]).get());
            if (tenantId.equals("Default")) {
                OidcConfig config = (OidcConfig)Arc.container().instance(OidcConfig.class, new Annotation[0]).get();
                this.tenantId = config.defaultTenant.getTenantId().orElse("Default");
            } else {
                this.tenantId = tenantId;
            }
        }

        @Override
        public Uni<SecurityIdentity> authenticate(AccessTokenCredential token) {
            return this.authenticate(new TokenAuthenticationRequest((TokenCredential)token));
        }

        @Override
        protected Uni<TenantConfigContext> resolveTenantConfigContext(TokenAuthenticationRequest request, AuthenticationRequestContext context) {
            return this.tenantResolver.resolveContext(this.tenantId).onItem().ifNull().failWith((Supplier)new Supplier<Throwable>(){

                @Override
                public Throwable get() {
                    return new OIDCException("Failed to resolve tenant context");
                }
            });
        }

        @Override
        protected Map<String, Object> getRequestData(TokenAuthenticationRequest request) {
            RoutingContext context = HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request);
            if (context != null) {
                return context.data();
            }
            return new HashMap<String, Object>();
        }

        private Uni<SecurityIdentity> authenticate(TokenAuthenticationRequest request) {
            return this.authenticate(request, new AuthenticationRequestContext(){

                public Uni<SecurityIdentity> runBlocking(Supplier<SecurityIdentity> function) {
                    return blockingExecutor.executeBlocking(function);
                }
            });
        }
    }
}

