/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.openshift.deployment;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.container.image.deployment.devconsole.RebuildHandler;
import io.quarkus.container.spi.AvailableContainerImageExtensionBuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.console.TempSystemProperties;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.openshift.runtime.devui.OpenshiftDeploymentJsonRpcService;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class OpenshiftDevConsoleProcessor {
    @BuildStep
    DevConsoleRouteBuildItem builder() {
        return new DevConsoleRouteBuildItem("deploy", "POST", (Handler)new RebuildHandler(Collections.singletonMap("quarkus.kubernetes.deploy", "true")));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    CardPageBuildItem create(List<AvailableContainerImageExtensionBuildItem> extensions) {
        JsonArray array = extensions.stream().map(AvailableContainerImageExtensionBuildItem::getName).sorted().collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
        CardPageBuildItem card = new CardPageBuildItem();
        card.addBuildTimeData("builderTypes", (Object)array);
        card.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Deploy to OpenShift")).componentLink("qwc-openshift-deployment.js").icon("font-awesome-solid:box"));
        return card;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem createJsonRPCServiceForContainerBuild() {
        DevConsoleManager.register((String)"openshift-deployment-action", this.build());
        return new JsonRPCProvidersBuildItem(OpenshiftDeploymentJsonRpcService.class);
    }

    private Function<Map<String, String>, String> build() {
        return map -> {
            QuarkusBootstrap existing = (QuarkusBootstrap)DevConsoleManager.getQuarkusBootstrap();
            try (TempSystemProperties properties = new TempSystemProperties();){
                String string;
                block15: {
                    properties.set("quarkus.kubernetes.deploy", "true");
                    for (Map.Entry arg : map.entrySet()) {
                        properties.set((String)arg.getKey(), (String)arg.getValue());
                    }
                    QuarkusBootstrap quarkusBootstrap = existing.clonedBuilder().setMode(QuarkusBootstrap.Mode.PROD).setIsolateDeployment(true).build();
                    CuratedApplication bootstrap = quarkusBootstrap.bootstrap();
                    try {
                        bootstrap.createAugmentor().createProductionApplication();
                        string = quarkusBootstrap.getBaseName() + " deployed successfully";
                        if (bootstrap == null) break block15;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bootstrap != null) {
                                try {
                                    bootstrap.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            String string2 = this.getRootMessage(e);
                            properties.close();
                            return string2;
                        }
                    }
                    bootstrap.close();
                }
                return string;
            }
        };
    }

    private String getRootMessage(Throwable e) {
        if (e.getCause() != null) {
            return this.getRootMessage(e.getCause());
        }
        return e.getMessage();
    }
}

