/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.opentelemetry.OpenTelemetryConfig;
import io.quarkus.opentelemetry.OpenTelemetryProducer;
import io.quarkus.opentelemetry.OpenTelemetryRecorder;
import io.quarkus.opentelemetry.QuarkusContextStorage;
import io.quarkus.opentelemetry.tracing.TracerProviderBuildItem;
import io.quarkus.runtime.RuntimeValue;
import java.util.Optional;
import java.util.function.BooleanSupplier;

public class OpenTelemetryProcessor {
    @BuildStep(onlyIf={OpenTelemetryEnabled.class})
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.OPENTELEMETRY);
    }

    @BuildStep(onlyIf={OpenTelemetryEnabled.class})
    AdditionalBeanBuildItem ensureProducerIsRetained() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(OpenTelemetryProducer.class).build();
    }

    @BuildStep(onlyIf={OpenTelemetryEnabled.class})
    void registerOpenTelemetryContextStorage(BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.opentelemetry.context.ContextStorageProvider"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{QuarkusContextStorage.class}));
    }

    @BuildStep(onlyIf={OpenTelemetryEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void createOpenTelemetry(OpenTelemetryRecorder recorder, Optional<TracerProviderBuildItem> tracerProviderBuildItem) {
        RuntimeValue tracerProvider = tracerProviderBuildItem.map(TracerProviderBuildItem::getTracerProvider).orElse(null);
        recorder.createOpenTelemetry(tracerProvider);
    }

    static class OpenTelemetryEnabled
    implements BooleanSupplier {
        OpenTelemetryConfig otelConfig;

        OpenTelemetryEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.otelConfig.enabled;
        }
    }
}

