/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.tracing;

import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.opentelemetry.OpenTelemetryConfig;
import io.quarkus.opentelemetry.tracing.TracerProducer;
import io.quarkus.opentelemetry.tracing.TracerProviderBuildItem;
import io.quarkus.opentelemetry.tracing.TracerRecorder;
import io.quarkus.opentelemetry.tracing.vertx.VertxTracerFilter;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.vertx.core.Handler;
import java.util.HashSet;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class TracerProcessor {
    private static final DotName SPAN_EXPORTER = DotName.createSimple((String)SpanExporter.class.getName());
    private static final DotName SPAN_PROCESSOR = DotName.createSimple((String)SpanProcessor.class.getName());

    @BuildStep(onlyIf={TracerEnabled.class})
    CapabilityBuildItem tracingCapability() {
        return new CapabilityBuildItem(Capability.OPENTELEMETRY_TRACER);
    }

    @BuildStep(onlyIf={TracerEnabled.class})
    UnremovableBeanBuildItem ensureProducersAreRetained(CombinedIndexBuildItem indexBuildItem, Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (capabilities.isPresent(Capability.OPENTRACING) || capabilities.isPresent(Capability.SMALLRYE_OPENTRACING)) {
            throw new ConfigurationException("The OpenTelemetry extension tracer can not be used in conjunction with either the SmallRye OpenTracing or Jaeger extensions.");
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(TracerProducer.class).build());
        IndexView index = indexBuildItem.getIndex();
        HashSet<String> knownClasses = new HashSet<String>();
        knownClasses.add(SPAN_EXPORTER.toString());
        index.getAllKnownImplementors(SPAN_EXPORTER).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(SPAN_PROCESSOR.toString());
        index.getAllKnownImplementors(SPAN_PROCESSOR).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        HashSet<String> retainProducers = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.PRODUCES)) {
            AnnotationTarget target = annotation.target();
            switch (target.kind()) {
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    String returnType = method.returnType().name().toString();
                    if (!knownClasses.contains(returnType)) break;
                    retainProducers.add(method.declaringClass().name().toString());
                    break;
                }
                case FIELD: {
                    FieldInfo field = target.asField();
                    String fieldType = field.type().name().toString();
                    if (!knownClasses.contains(fieldType)) break;
                    retainProducers.add(field.declaringClass().name().toString());
                    break;
                }
            }
        }
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNamesExclusion(retainProducers));
    }

    @BuildStep(onlyIf={TracerEnabled.class})
    FilterBuildItem addVertxTracerFilter() {
        return new FilterBuildItem((Handler)new VertxTracerFilter(), Integer.MAX_VALUE);
    }

    @BuildStep(onlyIf={TracerEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    TracerProviderBuildItem createTracerProvider(TracerRecorder recorder, ApplicationInfoBuildItem appInfo, ShutdownContextBuildItem shutdownContext, BeanContainerBuildItem beanContainerBuildItem) {
        String serviceName = appInfo.getName();
        String serviceVersion = appInfo.getVersion();
        return new TracerProviderBuildItem((RuntimeValue<SdkTracerProvider>)recorder.createTracerProvider(serviceName, serviceVersion, (ShutdownContext)shutdownContext));
    }

    public static class TracerEnabled
    implements BooleanSupplier {
        OpenTelemetryConfig otelConfig;

        @Override
        public boolean getAsBoolean() {
            return this.otelConfig.tracer.enabled.map(tracerEnabled -> this.otelConfig.enabled && tracerEnabled != false).orElseGet(() -> this.otelConfig.enabled);
        }
    }
}

