/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.tracing;

import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.Version;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.opentelemetry.deployment.OpenTelemetryProcessor;
import io.quarkus.opentelemetry.deployment.tracing.DropNonApplicationUrisBuildItem;
import io.quarkus.opentelemetry.deployment.tracing.DropStaticResourcesBuildItem;
import io.quarkus.opentelemetry.deployment.tracing.TracerEnabled;
import io.quarkus.opentelemetry.deployment.tracing.TracerProviderBuildItem;
import io.quarkus.opentelemetry.runtime.tracing.TracerProducer;
import io.quarkus.opentelemetry.runtime.tracing.TracerRecorder;
import io.quarkus.opentelemetry.runtime.tracing.TracerRuntimeConfig;
import io.quarkus.opentelemetry.runtime.tracing.grpc.GrpcTracingClientInterceptor;
import io.quarkus.opentelemetry.runtime.tracing.grpc.GrpcTracingServerInterceptor;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.core.deployment.VertxOptionsConsumerBuildItem;
import io.quarkus.vertx.http.deployment.spi.FrameworkEndpointsBuildItem;
import io.quarkus.vertx.http.deployment.spi.StaticResourcesBuildItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class TracerProcessor {
    private static final DotName ID_GENERATOR = DotName.createSimple((String)IdGenerator.class.getName());
    private static final DotName RESOURCE = DotName.createSimple((String)Resource.class.getName());
    private static final DotName SAMPLER = DotName.createSimple((String)Sampler.class.getName());
    private static final DotName SPAN_EXPORTER = DotName.createSimple((String)SpanExporter.class.getName());
    private static final DotName SPAN_PROCESSOR = DotName.createSimple((String)SpanProcessor.class.getName());

    @BuildStep(onlyIf={TracerEnabled.class})
    UnremovableBeanBuildItem ensureProducersAreRetained(CombinedIndexBuildItem indexBuildItem, Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (capabilities.isPresent("io.quarkus.opentracing") || capabilities.isPresent("io.quarkus.smallrye.opentracing")) {
            throw new ConfigurationException("The OpenTelemetry extension tracer can not be used in conjunction with either the SmallRye OpenTracing or Jaeger extensions.");
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(TracerProducer.class).build());
        IndexView index = indexBuildItem.getIndex();
        HashSet<String> knownClasses = new HashSet<String>();
        knownClasses.add(ID_GENERATOR.toString());
        index.getAllKnownImplementors(ID_GENERATOR).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(RESOURCE.toString());
        index.getAllKnownImplementors(RESOURCE).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(SAMPLER.toString());
        index.getAllKnownImplementors(SAMPLER).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(SPAN_EXPORTER.toString());
        index.getAllKnownImplementors(SPAN_EXPORTER).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(SPAN_PROCESSOR.toString());
        index.getAllKnownImplementors(SPAN_PROCESSOR).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        HashSet<String> retainProducers = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.PRODUCES)) {
            AnnotationTarget target = annotation.target();
            switch (target.kind()) {
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    String returnType = method.returnType().name().toString();
                    if (!knownClasses.contains(returnType)) break;
                    retainProducers.add(method.declaringClass().name().toString());
                    break;
                }
                case FIELD: {
                    FieldInfo field = target.asField();
                    String fieldType = field.type().name().toString();
                    if (!knownClasses.contains(fieldType)) break;
                    retainProducers.add(field.declaringClass().name().toString());
                    break;
                }
            }
        }
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNamesExclusion(retainProducers));
    }

    @BuildStep(onlyIf={TracerEnabled.class})
    void dropNames(Optional<FrameworkEndpointsBuildItem> frameworkEndpoints, Optional<StaticResourcesBuildItem> staticResources, BuildProducer<DropNonApplicationUrisBuildItem> dropNonApplicationUris, BuildProducer<DropStaticResourcesBuildItem> dropStaticResources) {
        ArrayList<String> nonApplicationUris = new ArrayList<String>();
        frameworkEndpoints.ifPresent(frameworkEndpointsBuildItem -> nonApplicationUris.addAll(frameworkEndpointsBuildItem.getEndpoints()));
        dropNonApplicationUris.produce((BuildItem)new DropNonApplicationUrisBuildItem(nonApplicationUris));
        ArrayList<String> resources = new ArrayList<String>();
        if (staticResources.isPresent()) {
            for (StaticResourcesBuildItem.Entry entry : staticResources.get().getEntries()) {
                if (entry.isDirectory()) continue;
                resources.add(entry.getPath());
            }
        }
        dropStaticResources.produce((BuildItem)new DropStaticResourcesBuildItem(resources));
    }

    @BuildStep(onlyIf={TracerEnabled.class, GrpcExtensionAvailable.class})
    void grpcTracers(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{GrpcTracingServerInterceptor.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{GrpcTracingClientInterceptor.class}));
    }

    @BuildStep(onlyIf={TracerEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    VertxOptionsConsumerBuildItem vertxTracingOptions(TracerRecorder recorder) {
        return new VertxOptionsConsumerBuildItem(recorder.getVertxTracingOptions(), 3000);
    }

    @BuildStep(onlyIf={TracerEnabled.class}, onlyIfNot={MetricsExtensionAvailable.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    VertxOptionsConsumerBuildItem vertxTracingMetricsOptions(TracerRecorder recorder) {
        return new VertxOptionsConsumerBuildItem(recorder.getVertxTracingMetricsOptions(), 3001);
    }

    @BuildStep(onlyIf={TracerEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    TracerProviderBuildItem createTracerProvider(TracerRecorder recorder, ApplicationInfoBuildItem appInfo, ShutdownContextBuildItem shutdownContext, BeanContainerBuildItem beanContainerBuildItem) {
        String serviceName = appInfo.getName();
        String serviceVersion = appInfo.getVersion();
        return new TracerProviderBuildItem((RuntimeValue<SdkTracerProvider>)recorder.createTracerProvider(Version.getVersion(), serviceName, serviceVersion, (ShutdownContext)shutdownContext));
    }

    @BuildStep(onlyIf={TracerEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupTracer(TracerRecorder recorder, TracerRuntimeConfig runtimeConfig, DropNonApplicationUrisBuildItem dropNonApplicationUris, DropStaticResourcesBuildItem dropStaticResources) {
        recorder.setupResources(runtimeConfig);
        recorder.setupSampler(runtimeConfig, dropNonApplicationUris.getDropNames(), dropStaticResources.getDropNames());
    }

    static class GrpcExtensionAvailable
    implements BooleanSupplier {
        private static final boolean IS_GRPC_EXTENSION_AVAILABLE = OpenTelemetryProcessor.isClassPresent("io.quarkus.grpc.runtime.GrpcServerRecorder");

        GrpcExtensionAvailable() {
        }

        @Override
        public boolean getAsBoolean() {
            return IS_GRPC_EXTENSION_AVAILABLE;
        }
    }

    static class MetricsExtensionAvailable
    implements BooleanSupplier {
        private static final boolean IS_MICROMETER_EXTENSION_AVAILABLE = OpenTelemetryProcessor.isClassPresent("io.quarkus.micrometer.runtime.binder.vertx.VertxHttpServerMetrics");

        MetricsExtensionAvailable() {
        }

        @Override
        public boolean getAsBoolean() {
            return IS_MICROMETER_EXTENSION_AVAILABLE && ConfigProvider.getConfig().getOptionalValue("quarkus.micrometer.binder.http-server.enabled", Boolean.class).orElse(true) != false;
        }
    }
}

