/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.dev;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceResultBuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesAdditionalConfigBuildItem;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.opentelemetry.deployment.OpenTelemetryEnabled;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;

public class DevServicesOpenTelemetryProcessor {
    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={OpenTelemetryEnabled.class, GlobalDevServicesConfig.Enabled.class})
    void devServicesDatasources(Optional<DevServicesDatasourceResultBuildItem> devServicesDatasources, BuildProducer<DevServicesAdditionalConfigBuildItem> devServicesAdditionalConfig) {
        if (devServicesDatasources.isPresent()) {
            Map namedDatasources;
            HashMap properties = new HashMap();
            DevServicesDatasourceResultBuildItem.DbResult defaultDatasource = devServicesDatasources.get().getDefaultDatasource();
            if (defaultDatasource != null) {
                properties.putAll(defaultDatasource.getConfigProperties());
            }
            if ((namedDatasources = devServicesDatasources.get().getNamedDatasources()) != null) {
                for (DevServicesDatasourceResultBuildItem.DbResult dbResult : namedDatasources.values()) {
                    if (dbResult == null) continue;
                    properties.putAll(dbResult.getConfigProperties());
                }
            }
            for (Map.Entry entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!key.endsWith(".url") || !value.startsWith("jdbc:")) continue;
                String driverKey = key.substring(0, key.length() - 4) + ".driver";
                ConfigValue driverValue = ConfigProvider.getConfig().getConfigValue(driverKey);
                if (driverValue.getValue() == null || !driverValue.getValue().equals("io.opentelemetry.instrumentation.jdbc.OpenTelemetryDriver")) continue;
                devServicesAdditionalConfig.produce((BuildItem)new DevServicesAdditionalConfigBuildItem(key, key, value.replaceFirst("jdbc:", "jdbc:otel:"), () -> {}));
            }
        }
    }
}

