/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.dev;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.DevServicesAdditionalConfigBuildItem;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.opentelemetry.deployment.OpenTelemetryEnabled;
import java.util.HashMap;
import java.util.List;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={OpenTelemetryEnabled.class, GlobalDevServicesConfig.Enabled.class})
public class DevServicesOpenTelemetryProcessor {
    @BuildStep
    void devServicesDatasources(List<JdbcDataSourceBuildItem> jdbcDataSources, BuildProducer<DevServicesAdditionalConfigBuildItem> devServicesAdditionalConfig) {
        for (JdbcDataSourceBuildItem dataSource : jdbcDataSources) {
            if (!this.dataSourceUsesOTelJdbcDriver(dataSource.getName())) continue;
            List urlPropertyKeys = DataSourceUtil.dataSourcePropertyKeys((String)dataSource.getName(), (String)"jdbc.url");
            devServicesAdditionalConfig.produce((BuildItem)new DevServicesAdditionalConfigBuildItem(devServicesConfig -> {
                HashMap<String, String> overrides = new HashMap<String, String>();
                for (String key : urlPropertyKeys) {
                    String devServicesUrl = (String)devServicesConfig.get(key);
                    if (devServicesUrl == null) continue;
                    overrides.put(key, devServicesUrl.replaceFirst("jdbc:", "jdbc:otel:"));
                }
                return overrides;
            }));
        }
    }

    private boolean dataSourceUsesOTelJdbcDriver(String dataSourceName) {
        List driverPropertyKeys = DataSourceUtil.dataSourcePropertyKeys((String)dataSourceName, (String)"jdbc.driver");
        for (String driverPropertyKey : driverPropertyKeys) {
            ConfigValue explicitlyConfiguredDriverValue = ConfigProvider.getConfig().getConfigValue(driverPropertyKey);
            if (explicitlyConfiguredDriverValue.getValue() == null) continue;
            return explicitlyConfiguredDriverValue.getValue().equals("io.opentelemetry.instrumentation.jdbc.OpenTelemetryDriver");
        }
        return false;
    }
}

