/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.tracing;

import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.Version;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.opentelemetry.deployment.tracing.TracerProviderBuildItem;
import io.quarkus.opentelemetry.runtime.OpenTelemetryConfig;
import io.quarkus.opentelemetry.runtime.tracing.TracerProducer;
import io.quarkus.opentelemetry.runtime.tracing.TracerRecorder;
import io.quarkus.opentelemetry.runtime.tracing.TracerRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.core.deployment.VertxOptionsConsumerBuildItem;
import java.util.HashSet;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class TracerProcessor {
    private static final DotName ID_GENERATOR = DotName.createSimple((String)IdGenerator.class.getName());
    private static final DotName RESOURCE = DotName.createSimple((String)Resource.class.getName());
    private static final DotName SAMPLER = DotName.createSimple((String)Sampler.class.getName());
    private static final DotName SPAN_EXPORTER = DotName.createSimple((String)SpanExporter.class.getName());
    private static final DotName SPAN_PROCESSOR = DotName.createSimple((String)SpanProcessor.class.getName());
    private static final String REST_CLIENT_LISTENER_CLASS_NAME = "org.eclipse.microprofile.rest.client.spi.RestClientListener";
    private static final boolean REST_CLIENT_LISTENER_CLASS_FOUND = TracerRecorder.isClassPresent((String)"org.eclipse.microprofile.rest.client.spi.RestClientListener");
    private static final String REST_CLIENT_TRACING_LISTENER = "io.quarkus.opentelemetry.runtime.tracing.restclient.QuarkusRestClientListener";

    @BuildStep(onlyIf={TracerEnabled.class, RestClientPresent.class})
    void registerRestClientListener(BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.eclipse.microprofile.rest.client.spi.RestClientListener"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{REST_CLIENT_TRACING_LISTENER}));
    }

    @BuildStep(onlyIf={TracerEnabled.class})
    UnremovableBeanBuildItem ensureProducersAreRetained(CombinedIndexBuildItem indexBuildItem, Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (capabilities.isPresent("io.quarkus.opentracing") || capabilities.isPresent("io.quarkus.smallrye.opentracing")) {
            throw new ConfigurationException("The OpenTelemetry extension tracer can not be used in conjunction with either the SmallRye OpenTracing or Jaeger extensions.");
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(TracerProducer.class).build());
        IndexView index = indexBuildItem.getIndex();
        HashSet<String> knownClasses = new HashSet<String>();
        knownClasses.add(ID_GENERATOR.toString());
        index.getAllKnownImplementors(ID_GENERATOR).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(RESOURCE.toString());
        index.getAllKnownImplementors(RESOURCE).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(SAMPLER.toString());
        index.getAllKnownImplementors(SAMPLER).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(SPAN_EXPORTER.toString());
        index.getAllKnownImplementors(SPAN_EXPORTER).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(SPAN_PROCESSOR.toString());
        index.getAllKnownImplementors(SPAN_PROCESSOR).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        HashSet<String> retainProducers = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.PRODUCES)) {
            AnnotationTarget target = annotation.target();
            switch (target.kind()) {
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    String returnType = method.returnType().name().toString();
                    if (!knownClasses.contains(returnType)) break;
                    retainProducers.add(method.declaringClass().name().toString());
                    break;
                }
                case FIELD: {
                    FieldInfo field = target.asField();
                    String fieldType = field.type().name().toString();
                    if (!knownClasses.contains(fieldType)) break;
                    retainProducers.add(field.declaringClass().name().toString());
                    break;
                }
            }
        }
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNamesExclusion(retainProducers));
    }

    @BuildStep(onlyIf={TracerEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    VertxOptionsConsumerBuildItem vertxTracingOptions(TracerRecorder recorder) {
        return new VertxOptionsConsumerBuildItem(recorder.setVertxTracingOptions(), 3000);
    }

    @BuildStep(onlyIf={TracerEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    TracerProviderBuildItem createTracerProvider(TracerRecorder recorder, ApplicationInfoBuildItem appInfo, ShutdownContextBuildItem shutdownContext, BeanContainerBuildItem beanContainerBuildItem) {
        String serviceName = appInfo.getName();
        String serviceVersion = appInfo.getVersion();
        return new TracerProviderBuildItem((RuntimeValue<SdkTracerProvider>)recorder.createTracerProvider(Version.getVersion(), serviceName, serviceVersion, (ShutdownContext)shutdownContext));
    }

    @BuildStep(onlyIf={TracerEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupTracer(TracerRuntimeConfig runtimeConfig, TracerRecorder recorder) {
        recorder.setupResources(runtimeConfig);
        recorder.setupSampler(runtimeConfig);
        recorder.setupVertxTracer();
    }

    static class RestClientPresent
    implements BooleanSupplier {
        RestClientPresent() {
        }

        @Override
        public boolean getAsBoolean() {
            return REST_CLIENT_LISTENER_CLASS_FOUND;
        }
    }

    public static class TracerEnabled
    implements BooleanSupplier {
        OpenTelemetryConfig otelConfig;

        @Override
        public boolean getAsBoolean() {
            return this.otelConfig.tracer.enabled.map(tracerEnabled -> this.otelConfig.enabled && tracerEnabled != false).orElseGet(() -> this.otelConfig.enabled);
        }
    }
}

