/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment;

import io.opentelemetry.extension.annotations.WithSpan;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.InterceptorBindingRegistrarBuildItem;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.opentelemetry.deployment.tracing.TracerProviderBuildItem;
import io.quarkus.opentelemetry.runtime.OpenTelemetryConfig;
import io.quarkus.opentelemetry.runtime.OpenTelemetryProducer;
import io.quarkus.opentelemetry.runtime.OpenTelemetryRecorder;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.quarkus.opentelemetry.runtime.tracing.cdi.WithSpanInterceptor;
import io.quarkus.opentelemetry.runtime.tracing.restclient.OpenTelemetryClientFilter;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.deployment.CopyVertxContextDataBuildItem;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class OpenTelemetryProcessor {
    @BuildStep(onlyIf={OpenTelemetryEnabled.class})
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.OPENTELEMETRY);
    }

    @BuildStep(onlyIf={OpenTelemetryEnabled.class})
    AdditionalBeanBuildItem ensureProducerIsRetained() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(OpenTelemetryProducer.class).build();
    }

    @BuildStep(onlyIf={OpenTelemetryEnabled.class})
    void registerOpenTelemetryContextStorage(BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.opentelemetry.context.ContextStorageProvider"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{QuarkusContextStorage.class}));
    }

    @BuildStep(onlyIf={OpenTelemetryEnabled.class})
    void registerWithSpan(BuildProducer<InterceptorBindingRegistrarBuildItem> interceptorBindingRegistrar, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        interceptorBindingRegistrar.produce((BuildItem)new InterceptorBindingRegistrarBuildItem(new InterceptorBindingRegistrar(){

            public List<InterceptorBindingRegistrar.InterceptorBinding> getAdditionalBindings() {
                return List.of(InterceptorBindingRegistrar.InterceptorBinding.of(WithSpan.class, Set.of("value", "kind")));
            }
        }));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{WithSpanInterceptor.class}));
    }

    @BuildStep(onlyIf={OpenTelemetryEnabled.class})
    void transformWithSpan(BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(transformationContext -> {
            AnnotationTarget target = transformationContext.getTarget();
            if (target.kind().equals((Object)AnnotationTarget.Kind.CLASS) && target.asClass().name().equals((Object)DotName.createSimple((String)WithSpanInterceptor.class.getName()))) {
                ((Transformation)transformationContext.transform().add(DotName.createSimple((String)WithSpan.class.getName()), new AnnotationValue[0])).done();
            }
        }));
    }

    @BuildStep(onlyIf={OpenTelemetryEnabled.class, RestClientAvailable.class})
    void registerProvider(BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexed, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalIndexed.produce((BuildItem)new AdditionalIndexedClassesBuildItem(OpenTelemetryClientFilter.class.getName()));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{OpenTelemetryClientFilter.class}));
    }

    @BuildStep(onlyIf={OpenTelemetryEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void createOpenTelemetry(OpenTelemetryConfig openTelemetryConfig, OpenTelemetryRecorder recorder, Optional<TracerProviderBuildItem> tracerProviderBuildItem, LaunchModeBuildItem launchMode) {
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT || launchMode.getLaunchMode() == LaunchMode.TEST) {
            recorder.resetGlobalOpenTelemetryForDevMode();
        }
        RuntimeValue tracerProvider = tracerProviderBuildItem.map(TracerProviderBuildItem::getTracerProvider).orElse(null);
        recorder.createOpenTelemetry(tracerProvider, openTelemetryConfig);
        recorder.eagerlyCreateContextStorage();
    }

    @BuildStep(onlyIf={OpenTelemetryEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void storeVertxOnContextStorage(OpenTelemetryRecorder recorder, CoreVertxBuildItem vertx) {
        recorder.storeVertxOnContextStorage(vertx.getVertx());
    }

    @BuildStep
    CopyVertxContextDataBuildItem copyVertxContextData() {
        return new CopyVertxContextDataBuildItem(QuarkusContextStorage.ACTIVE_CONTEXT);
    }

    public static boolean isClassPresent(String classname) {
        try {
            Class.forName(classname, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static class RestClientAvailable
    implements BooleanSupplier {
        private static final boolean IS_REST_CLIENT_AVAILABLE = OpenTelemetryProcessor.isClassPresent("javax.ws.rs.client.ClientRequestFilter");

        RestClientAvailable() {
        }

        @Override
        public boolean getAsBoolean() {
            return IS_REST_CLIENT_AVAILABLE;
        }
    }

    static class OpenTelemetryEnabled
    implements BooleanSupplier {
        OpenTelemetryConfig otelConfig;

        OpenTelemetryEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.otelConfig.enabled;
        }
    }
}

