/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.tracing.instrumentation;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.opentelemetry.deployment.tracing.TracerEnabled;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.InstrumentationRecorder;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.grpc.GrpcTracingClientInterceptor;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.grpc.GrpcTracingServerInterceptor;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.reactivemessaging.ReactiveMessagingTracingDecorator;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.restclient.OpenTelemetryClientFilter;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.resteasy.AttachExceptionHandler;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.resteasy.OpenTelemetryClassicServerFilter;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.resteasy.OpenTelemetryReactiveServerFilter;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.server.spi.PreExceptionMapperHandlerBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomContainerRequestFilterBuildItem;
import io.quarkus.vertx.core.deployment.VertxOptionsConsumerBuildItem;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

@BuildSteps(onlyIf={TracerEnabled.class})
public class InstrumentationProcessor {
    @BuildStep(onlyIf={GrpcExtensionAvailable.class})
    void grpcTracers(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{GrpcTracingServerInterceptor.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{GrpcTracingClientInterceptor.class}));
    }

    @BuildStep
    void registerRestClientClassicProvider(Capabilities capabilities, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexed, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (capabilities.isPresent("io.quarkus.rest.client") && capabilities.isMissing("io.quarkus.rest.client.reactive")) {
            additionalIndexed.produce((BuildItem)new AdditionalIndexedClassesBuildItem(OpenTelemetryClientFilter.class.getName()));
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{OpenTelemetryClientFilter.class}));
        }
    }

    @BuildStep
    void registerReactiveMessagingMessageDecorator(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (capabilities.isPresent("io.quarkus.smallrye.reactive.messaging")) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ReactiveMessagingTracingDecorator.class}));
        }
    }

    @BuildStep(onlyIfNot={MetricsExtensionAvailable.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    VertxOptionsConsumerBuildItem vertxTracingMetricsOptions(InstrumentationRecorder recorder) {
        return new VertxOptionsConsumerBuildItem(recorder.getVertxTracingMetricsOptions(), 3001);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    VertxOptionsConsumerBuildItem vertxTracingOptions(InstrumentationRecorder recorder) {
        Consumer vertxTracingOptions = recorder.getVertxTracingOptions();
        return new VertxOptionsConsumerBuildItem(vertxTracingOptions, 3000);
    }

    @BuildStep
    void registerResteasyClassicAndOrResteasyReactiveProvider(Capabilities capabilities, BuildProducer<ResteasyJaxrsProviderBuildItem> resteasyJaxrsProviderBuildItemBuildProducer) {
        boolean isResteasyClassicAvailable = capabilities.isPresent("io.quarkus.resteasy");
        if (!isResteasyClassicAvailable) {
            return;
        }
        resteasyJaxrsProviderBuildItemBuildProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(OpenTelemetryClassicServerFilter.class.getName()));
    }

    @BuildStep
    void resteasyReactiveIntegration(Capabilities capabilities, BuildProducer<CustomContainerRequestFilterBuildItem> containerRequestFilterBuildItemBuildProducer, BuildProducer<PreExceptionMapperHandlerBuildItem> preExceptionMapperHandlerBuildItemBuildProducer) {
        if (!capabilities.isPresent("io.quarkus.resteasy.reactive")) {
            return;
        }
        containerRequestFilterBuildItemBuildProducer.produce((BuildItem)new CustomContainerRequestFilterBuildItem(OpenTelemetryReactiveServerFilter.class.getName()));
        preExceptionMapperHandlerBuildItemBuildProducer.produce((BuildItem)new PreExceptionMapperHandlerBuildItem((ServerRestHandler)new AttachExceptionHandler()));
    }

    static class GrpcExtensionAvailable
    implements BooleanSupplier {
        private static final boolean IS_GRPC_EXTENSION_AVAILABLE = QuarkusClassLoader.isClassPresentAtRuntime((String)"io.quarkus.grpc.runtime.GrpcServerRecorder");

        GrpcExtensionAvailable() {
        }

        @Override
        public boolean getAsBoolean() {
            return IS_GRPC_EXTENSION_AVAILABLE;
        }
    }

    static class MetricsExtensionAvailable
    implements BooleanSupplier {
        private static final boolean IS_MICROMETER_EXTENSION_AVAILABLE = QuarkusClassLoader.isClassPresentAtRuntime((String)"io.quarkus.micrometer.runtime.binder.vertx.VertxHttpServerMetrics");

        MetricsExtensionAvailable() {
        }

        @Override
        public boolean getAsBoolean() {
            Config config = ConfigProvider.getConfig();
            if (IS_MICROMETER_EXTENSION_AVAILABLE && config.getOptionalValue("quarkus.micrometer.enabled", Boolean.class).orElse(true).booleanValue()) {
                Optional httpServerEnabled = config.getOptionalValue("quarkus.micrometer.binder.http-server.enabled", Boolean.class);
                if (httpServerEnabled.isPresent()) {
                    return (Boolean)httpServerEnabled.get();
                }
                return config.getOptionalValue("quarkus.micrometer.binder-enabled-default", Boolean.class).orElse(true);
            }
            return false;
        }
    }
}

