/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurablePropagatorProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSamplerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.OpenTelemetryInitBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.InterceptorBindingRegistrarBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.opentelemetry.deployment.OpenTelemetryEnabled;
import io.quarkus.opentelemetry.runtime.OpenTelemetryProducer;
import io.quarkus.opentelemetry.runtime.OpenTelemetryRecorder;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.quarkus.opentelemetry.runtime.tracing.cdi.WithSpanInterceptor;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.InstrumentationRecorder;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

@BuildSteps(onlyIf={OpenTelemetryEnabled.class})
public class OpenTelemetryProcessor {
    private static final DotName LEGACY_WITH_SPAN = DotName.createSimple((String)io.opentelemetry.extension.annotations.WithSpan.class.getName());
    private static final DotName WITH_SPAN = DotName.createSimple((String)WithSpan.class.getName());
    private static final DotName SPAN_KIND = DotName.createSimple((String)SpanKind.class.getName());
    private static final DotName WITH_SPAN_INTERCEPTOR = DotName.createSimple((String)WithSpanInterceptor.class.getName());
    private static final DotName SPAN_ATTRIBUTE = DotName.createSimple((String)SpanAttribute.class.getName());

    @BuildStep
    AdditionalBeanBuildItem ensureProducerIsRetained() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(OpenTelemetryProducer.class).build();
    }

    @BuildStep
    void registerNativeImageResources(BuildProducer<ServiceProviderBuildItem> services) throws IOException {
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ConfigurableSpanExporterProvider.class.getName()));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ConfigurableSamplerProvider.class.getName()));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)AutoConfigurationCustomizerProvider.class.getName()));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ResourceProvider.class.getName()));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ConfigurablePropagatorProvider.class.getName()));
    }

    @BuildStep
    void registerOpenTelemetryContextStorage(BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.opentelemetry.context.ContextStorageProvider"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{QuarkusContextStorage.class}).methods().fields().build());
    }

    @BuildStep
    void registerWithSpan(BuildProducer<InterceptorBindingRegistrarBuildItem> interceptorBindingRegistrar, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        interceptorBindingRegistrar.produce((BuildItem)new InterceptorBindingRegistrarBuildItem(new InterceptorBindingRegistrar(){

            public List<InterceptorBindingRegistrar.InterceptorBinding> getAdditionalBindings() {
                return List.of(InterceptorBindingRegistrar.InterceptorBinding.of(WithSpan.class, Set.of("value", "kind")));
            }
        }));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{WithSpanInterceptor.class}));
    }

    @BuildStep
    void transformWithSpan(BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.METHOD;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                AnnotationTarget target = context.getTarget();
                List legacyWithSpans = context.getAnnotations().stream().filter(annotationInstance -> annotationInstance.name().equals((Object)LEGACY_WITH_SPAN)).collect(Collectors.toList());
                for (AnnotationInstance legacyAnnotation : legacyWithSpans) {
                    AnnotationValue value = Optional.ofNullable(legacyAnnotation.value("value")).orElse(AnnotationValue.createStringValue((String)"value", (String)""));
                    AnnotationValue kind = Optional.ofNullable(legacyAnnotation.value("kind")).orElse(AnnotationValue.createEnumValue((String)"kind", (DotName)SPAN_KIND, (String)SpanKind.INTERNAL.name()));
                    AnnotationInstance annotation = AnnotationInstance.create((DotName)WITH_SPAN, (AnnotationTarget)target, List.of(value, kind));
                    ((Transformation)context.transform().add(annotation)).done();
                }
            }
        }));
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(transformationContext -> {
            AnnotationTarget target = transformationContext.getTarget();
            if (target.kind().equals((Object)AnnotationTarget.Kind.CLASS) && target.asClass().name().equals((Object)WITH_SPAN_INTERCEPTOR)) {
                ((Transformation)transformationContext.transform().add(WITH_SPAN, new AnnotationValue[0])).done();
            }
        }));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Produce(value=OpenTelemetryInitBuildItem.class)
    void createOpenTelemetry(OpenTelemetryRecorder recorder, InstrumentationRecorder instrumentationRecorder, CoreVertxBuildItem vertx, LaunchModeBuildItem launchMode, ShutdownContextBuildItem shutdownContextBuildItem) {
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT || launchMode.getLaunchMode() == LaunchMode.TEST) {
            recorder.resetGlobalOpenTelemetryForDevMode();
        }
        RuntimeValue openTelemetry = recorder.createOpenTelemetry((ShutdownContext)shutdownContextBuildItem);
        recorder.eagerlyCreateContextStorage();
        recorder.storeVertxOnContextStorage(vertx.getVertx());
        instrumentationRecorder.setTracer(instrumentationRecorder.createTracers(openTelemetry));
    }

    @BuildStep
    void validateDataSourcesWithEnabledTelemetry(List<JdbcDataSourceBuildItem> jdbcDataSources, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        for (JdbcDataSourceBuildItem dataSource : jdbcDataSources) {
            String dataSourceName = dataSource.getName();
            if (!OpenTelemetryProcessor.dataSourceUsesOTelJdbcDriver(dataSourceName)) continue;
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new ConfigurationException(String.format("Data source '%s' is using unsupported JDBC driver '%s', please activate JDBC instrumentation by setting the 'quarkus.datasource.jdbc.telemetry' configuration property to 'true' instead", dataSourceName, "io.opentelemetry.instrumentation.jdbc.OpenTelemetryDriver"))}));
        }
    }

    private static boolean dataSourceUsesOTelJdbcDriver(String dataSourceName) {
        List driverPropertyKeys = DataSourceUtil.dataSourcePropertyKeys((String)dataSourceName, (String)"jdbc.driver");
        for (String driverPropertyKey : driverPropertyKeys) {
            ConfigValue explicitlyConfiguredDriverValue = ConfigProvider.getConfig().getConfigValue(driverPropertyKey);
            if (explicitlyConfiguredDriverValue.getValue() == null) continue;
            return explicitlyConfiguredDriverValue.getValue().equals("io.opentelemetry.instrumentation.jdbc.OpenTelemetryDriver");
        }
        return false;
    }
}

