/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.tracing;

import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.Version;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.opentelemetry.deployment.tracing.DropNonApplicationUrisBuildItem;
import io.quarkus.opentelemetry.deployment.tracing.DropStaticResourcesBuildItem;
import io.quarkus.opentelemetry.deployment.tracing.TracerEnabled;
import io.quarkus.opentelemetry.runtime.tracing.TracerRecorder;
import io.quarkus.opentelemetry.runtime.tracing.cdi.TracerProducer;
import io.quarkus.vertx.http.deployment.spi.FrameworkEndpointsBuildItem;
import io.quarkus.vertx.http.deployment.spi.StaticResourcesBuildItem;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

@BuildSteps(onlyIf={TracerEnabled.class})
public class TracerProcessor {
    private static final DotName ID_GENERATOR = DotName.createSimple((String)IdGenerator.class.getName());
    private static final DotName RESOURCE = DotName.createSimple((String)Resource.class.getName());
    private static final DotName SAMPLER = DotName.createSimple((String)Sampler.class.getName());
    private static final DotName SPAN_EXPORTER = DotName.createSimple((String)SpanExporter.class.getName());
    private static final DotName SPAN_PROCESSOR = DotName.createSimple((String)SpanProcessor.class.getName());
    private static final DotName TEXT_MAP_PROPAGATOR = DotName.createSimple((String)TextMapPropagator.class.getName());

    @BuildStep
    UnremovableBeanBuildItem ensureProducersAreRetained(CombinedIndexBuildItem indexBuildItem, Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(TracerProducer.class).build());
        IndexView index = indexBuildItem.getIndex();
        HashSet<String> knownClasses = new HashSet<String>();
        knownClasses.add(ID_GENERATOR.toString());
        index.getAllKnownImplementors(ID_GENERATOR).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(RESOURCE.toString());
        index.getAllKnownImplementors(RESOURCE).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(SAMPLER.toString());
        index.getAllKnownImplementors(SAMPLER).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(SPAN_EXPORTER.toString());
        index.getAllKnownImplementors(SPAN_EXPORTER).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(SPAN_PROCESSOR.toString());
        index.getAllKnownImplementors(SPAN_PROCESSOR).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(TEXT_MAP_PROPAGATOR.toString());
        index.getAllKnownImplementors(TEXT_MAP_PROPAGATOR).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        HashSet<String> retainProducers = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.PRODUCES)) {
            AnnotationTarget target = annotation.target();
            switch (target.kind()) {
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    String returnType = method.returnType().name().toString();
                    if (!knownClasses.contains(returnType)) break;
                    retainProducers.add(method.declaringClass().name().toString());
                    break;
                }
                case FIELD: {
                    FieldInfo field = target.asField();
                    String fieldType = field.type().name().toString();
                    if (!knownClasses.contains(fieldType)) break;
                    retainProducers.add(field.declaringClass().name().toString());
                    break;
                }
            }
        }
        return new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNamesExclusion(retainProducers));
    }

    @BuildStep
    void dropNames(Optional<FrameworkEndpointsBuildItem> frameworkEndpoints, Optional<StaticResourcesBuildItem> staticResources, BuildProducer<DropNonApplicationUrisBuildItem> dropNonApplicationUris, BuildProducer<DropStaticResourcesBuildItem> dropStaticResources) {
        ArrayList<String> nonApplicationUris = new ArrayList<String>();
        frameworkEndpoints.ifPresent(frameworkEndpointsBuildItem -> {
            for (String endpoint : frameworkEndpointsBuildItem.getEndpoints()) {
                if (endpoint.startsWith("http://") || endpoint.startsWith("https://")) {
                    try {
                        nonApplicationUris.add(new URL(endpoint).getPath());
                    }
                    catch (Exception ignored) {
                        nonApplicationUris.add(endpoint);
                    }
                    continue;
                }
                nonApplicationUris.add(endpoint);
            }
        });
        dropNonApplicationUris.produce((BuildItem)new DropNonApplicationUrisBuildItem(nonApplicationUris));
        ArrayList<String> resources = new ArrayList<String>();
        if (staticResources.isPresent()) {
            for (StaticResourcesBuildItem.Entry entry : staticResources.get().getEntries()) {
                if (entry.isDirectory()) continue;
                resources.add(entry.getPath());
            }
        }
        dropStaticResources.produce((BuildItem)new DropStaticResourcesBuildItem(resources));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void staticInitSetup(TracerRecorder recorder, ApplicationInfoBuildItem appInfo, BeanContainerBuildItem beanContainerBuildItem, DropNonApplicationUrisBuildItem dropNonApplicationUris, DropStaticResourcesBuildItem dropStaticResources) {
        recorder.setAttributes(beanContainerBuildItem.getValue(), Version.getVersion(), appInfo.getName(), appInfo.getVersion());
        recorder.setupSampler(dropNonApplicationUris.getDropNames(), dropStaticResources.getDropNames());
    }
}

