/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.exporter.jaeger.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.opentelemetry.exporter.jaeger.runtime.JaegerExporterConfig;
import io.quarkus.opentelemetry.exporter.jaeger.runtime.JaegerExporterProvider;
import io.quarkus.opentelemetry.exporter.jaeger.runtime.JaegerRecorder;
import java.util.function.BooleanSupplier;

public class JaegerExporterProcessor {
    @BuildStep(onlyIf={JaegerExporterEnabled.class})
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.OPENTELEMETRY_JAEGER_EXPORTER);
    }

    @BuildStep(onlyIf={JaegerExporterEnabled.class})
    AdditionalBeanBuildItem createBatchSpanProcessor() {
        return AdditionalBeanBuildItem.builder().addBeanClass(JaegerExporterProvider.class).setUnremovable().build();
    }

    @BuildStep(onlyIf={JaegerExporterEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void installBatchSpanProcessorForJaeger(JaegerRecorder recorder, LaunchModeBuildItem launchModeBuildItem, JaegerExporterConfig.JaegerExporterRuntimeConfig runtimeConfig) {
        recorder.installBatchSpanProcessorForJaeger(runtimeConfig, launchModeBuildItem.getLaunchMode());
    }

    static class JaegerExporterEnabled
    implements BooleanSupplier {
        JaegerExporterConfig.JaegerExporterBuildConfig jaegerExporterConfig;

        JaegerExporterEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.jaegerExporterConfig.enabled;
        }
    }
}

