/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.exporter.jaeger;

import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.quarkus.opentelemetry.exporter.jaeger.JaegerExporterConfig;
import io.quarkus.opentelemetry.exporter.jaeger.LateBoundBatchSpanProcessor;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.CDI;

@Recorder
public class JaegerRecorder {
    public void installBatchSpanProcessorForJaeger(JaegerExporterConfig.JaegerExporterRuntimeConfig runtimeConfig) {
        if (runtimeConfig.endpoint != null && runtimeConfig.endpoint.trim().length() > 0) {
            try {
                JaegerGrpcSpanExporter jaegerSpanExporter = JaegerGrpcSpanExporter.builder().setEndpoint(runtimeConfig.endpoint).setTimeout(runtimeConfig.exportTimeout).build();
                LateBoundBatchSpanProcessor delayedProcessor = (LateBoundBatchSpanProcessor)CDI.current().select(LateBoundBatchSpanProcessor.class, new Annotation[]{Any.Literal.INSTANCE}).get();
                delayedProcessor.setBatchSpanProcessorDelegate(BatchSpanProcessor.builder((SpanExporter)jaegerSpanExporter).build());
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalStateException("Unable to install Jaeger Exporter", iae);
            }
        }
    }
}

